/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent;

import dev.shortloop.agent.SDKLogger;
import dev.shortloop.agent.ShortloopSpringFilter;
import dev.shortloop.agent.buffer.ApiBufferKey;
import dev.shortloop.agent.buffer.BufferManagerWorker;
import dev.shortloop.agent.buffer.DiscoveredApiBufferManager;
import dev.shortloop.agent.buffer.RegisteredApiBufferManager;
import dev.shortloop.common.models.data.APISample;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class ShortloopApiProcessor {
    private final RegisteredApiBufferManager registeredApiBufferManager;
    private final DiscoveredApiBufferManager discoveredApiBufferManager;
    private final SDKLogger logger;

    public void processDiscoveredApi(ShortloopSpringFilter.RequestResponseContext context, FilterChain filterChain) throws ServletException, IOException {
        BufferManagerWorker<ApiBufferKey> worker = this.discoveredApiBufferManager.getWorker();
        if (null == worker) {
            this.logger.error("BufferManagerWorker is NULL inside RegisteredApiProcessor");
            this.doFilter(filterChain, context);
            return;
        }
        boolean canOffer = worker.canOffer(context.getApiBufferKey());
        context.setRequestPayloadOmitted(true);
        context.setResponsePayloadOmitted(true);
        try {
            this.doFilter(filterChain, context);
        }
        catch (Exception exception) {
            if (canOffer) {
                this.tryOffering(context, exception, worker);
            }
            throw exception;
        }
        if (canOffer) {
            this.tryOffering(context, null, worker);
        }
    }

    public void processRegisteredApi(ShortloopSpringFilter.RequestResponseContext context, FilterChain filterChain) throws ServletException, IOException {
        BufferManagerWorker<ApiBufferKey> worker = this.registeredApiBufferManager.getWorker();
        if (null == worker) {
            this.logger.error("BufferManagerWorker is NULL inside RegisteredApiProcessor");
            this.doFilter(filterChain, context);
            return;
        }
        boolean canOffer = worker.canOffer(context.getApiBufferKey());
        boolean shouldCaptureRequest = false;
        boolean shouldCaptureResponse = false;
        if (canOffer) {
            shouldCaptureRequest = this.shouldCaptureRequest(context);
            if (shouldCaptureRequest) {
                context.setCachedRequest(ShortloopApiProcessor.wrapRequest(context.getServletRequest()));
            }
            if (shouldCaptureResponse = this.shouldCaptureResponse(context)) {
                context.setCachedResponse(ShortloopApiProcessor.wrapResponse(context.getServletResponse()));
            }
            context.setRequestPayloadOmitted(!shouldCaptureRequest);
            context.setResponsePayloadOmitted(!shouldCaptureResponse);
        }
        try {
            boolean shouldComputeLatency;
            long startTime = 0L;
            boolean bl = shouldComputeLatency = canOffer && shouldCaptureRequest && shouldCaptureResponse;
            if (shouldComputeLatency) {
                startTime = System.currentTimeMillis();
            }
            this.doFilter(filterChain, context);
            if (shouldComputeLatency) {
                context.setLatency(System.currentTimeMillis() - startTime);
            }
        }
        catch (Exception exception) {
            if (canOffer) {
                this.tryOffering(context, exception, worker);
            }
            throw exception;
        }
        if (canOffer) {
            this.tryOffering(context, null, worker);
        }
    }

    private void tryOffering(ShortloopSpringFilter.RequestResponseContext context, Exception exception, BufferManagerWorker<ApiBufferKey> worker) {
        try {
            APISample apiSample = this.getBufferEntryForApiSample(context, exception);
            if (null != apiSample) {
                worker.offer(context.getApiBufferKey(), apiSample);
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private void doFilter(FilterChain filterChain, ShortloopSpringFilter.RequestResponseContext context) throws ServletException, IOException {
        ContentCachingRequestWrapper servletRequest = null != context.getCachedRequest() ? context.getCachedRequest() : context.getServletRequest();
        ContentCachingResponseWrapper servletResponse = null != context.getCachedResponse() ? context.getCachedResponse() : context.getServletResponse();
        filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
    }

    private boolean shouldCaptureRequest(ShortloopSpringFilter.RequestResponseContext context) {
        return null == context.getApiConfig() || null == context.getApiConfig().getCaptureSample() || context.getApiConfig().getCaptureSample() != false;
    }

    private boolean shouldCaptureResponse(ShortloopSpringFilter.RequestResponseContext context) {
        return null == context.getApiConfig() || null == context.getApiConfig().getCaptureSample() || context.getApiConfig().getCaptureSample() != false;
    }

    private APISample getBufferEntryForApiSample(ShortloopSpringFilter.RequestResponseContext context, Exception exception) {
        APISample apiSample = new APISample();
        apiSample.setApplicationName(context.getApplicationName());
        try {
            if (null != context.getApiConfig()) {
                apiSample.setMethod(context.getApiConfig().getMethod());
            } else {
                apiSample.setMethod(context.getObservedApi().getMethod());
            }
            apiSample.setRawUri(context.getObservedApi().getUri().getUriPath());
            apiSample.setParameters(this.getParameters(context.getServletRequest()));
            apiSample.setRequestHeaders(this.getRequestHeaders(context));
            apiSample.setResponseHeaders(this.getResponseHeaders(context));
            apiSample.setLatency(context.getLatency());
            apiSample.setHostName(context.getServletRequest().getServerName());
            if (null != context.getCachedRequest()) {
                apiSample.setRequestPayload(new String(context.getCachedRequest().getContentAsByteArray()));
            }
            apiSample.setStatusCode(context.getServletResponse().getStatus());
            if (null == exception) {
                if (null != context.getCachedResponse()) {
                    apiSample.setResponsePayload(new String(context.getCachedResponse().getContentAsByteArray()));
                    context.getCachedResponse().copyBodyToResponse();
                    apiSample.setStatusCode(context.getCachedResponse().getStatus());
                }
            } else {
                apiSample.setUncaughtExceptionMessage(exception.getCause().getMessage());
                apiSample.setStatusCode(500);
            }
            apiSample.setRequestPayloadOmitted(context.getRequestPayloadOmitted());
            apiSample.setResponsePayloadOmitted(context.getResponsePayloadOmitted());
        }
        catch (Exception e) {
            this.logger.error("Error create bufferEntry for API", e);
        }
        return apiSample;
    }

    private static ContentCachingRequestWrapper wrapRequest(HttpServletRequest request) {
        if (request instanceof ContentCachingRequestWrapper) {
            return (ContentCachingRequestWrapper)request;
        }
        return new ContentCachingRequestWrapper(request);
    }

    private static ContentCachingResponseWrapper wrapResponse(HttpServletResponse response) {
        if (response instanceof ContentCachingResponseWrapper) {
            return (ContentCachingResponseWrapper)response;
        }
        return new ContentCachingResponseWrapper(response);
    }

    private Map<String, String> getRequestHeaders(ShortloopSpringFilter.RequestResponseContext context) {
        Object httpServletRequest = null;
        httpServletRequest = null != context.getCachedRequest() ? context.getCachedRequest() : context.getServletRequest();
        if (null == httpServletRequest) {
            return new HashMap<String, String>();
        }
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                headerMap.put(headerName, httpServletRequest.getHeader(headerName));
            }
        }
        return headerMap;
    }

    private Map<String, String> getResponseHeaders(ShortloopSpringFilter.RequestResponseContext context) {
        Object httpServletResponse = null;
        httpServletResponse = null != context.getCachedRequest() ? context.getCachedResponse() : context.getServletResponse();
        if (null == httpServletResponse || null == httpServletResponse.getHeaderNames()) {
            return new HashMap<String, String>();
        }
        Collection headerNames = httpServletResponse.getHeaderNames();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String header : headerNames) {
            headerMap.put(header, httpServletResponse.getHeader(header));
        }
        headerMap.put("Content-Type", httpServletResponse.getContentType());
        return headerMap;
    }

    private Map<String, String[]> getParameters(HttpServletRequest servletRequest) {
        Map servletParameterMap = servletRequest.getParameterMap();
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        for (String key : servletParameterMap.keySet()) {
            parameterMap.put(key, (String[])servletParameterMap.get(key));
        }
        return parameterMap;
    }

    public ShortloopApiProcessor(RegisteredApiBufferManager registeredApiBufferManager, DiscoveredApiBufferManager discoveredApiBufferManager, SDKLogger logger) {
        this.registeredApiBufferManager = registeredApiBufferManager;
        this.discoveredApiBufferManager = discoveredApiBufferManager;
        this.logger = logger;
    }
}

