package dev.shortloop.agent;

import dev.shortloop.agent.config.SimpleConfigManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SDKLogger {
    boolean loggingEnabled;
    LogLevel logLevel;

    Log logger;
    public SDKLogger(boolean loggingEnabled, LogLevel logLevel) {
        this.loggingEnabled = loggingEnabled;
        this.logLevel = logLevel;
        logger = LogFactory.getLog(SDKLogger.class);
    }

    public enum LogLevel {
        INFO,
        ERROR
    }

    public void info(Object object) {
        if (loggingEnabled && logLevel == LogLevel.INFO && null != logger) {
            logger.info(object);
        }
    }

    public void forceLog(Object object) {
        if (null != logger) {
            logger.info(object);
        }
    }

    public void info(Object object, Throwable throwable) {
        if (loggingEnabled && logLevel == LogLevel.INFO && null != logger) {
            logger.info(object, throwable);
        }
    }

    public boolean canLogError() {
        return loggingEnabled && (logLevel == LogLevel.INFO || logLevel == LogLevel.ERROR) && null != logger;
    }

    public void error(Object object) {
        if (canLogError()) {
            logger.error(object);
        }
    }

    public void error(Object object, Throwable throwable) {
        if (canLogError()) {
            logger.error(object, throwable);
        }
    }
}
