package dev.shortloop.agent.commons;


import dev.shortloop.common.models.constant.ShortloopCommonConstant;
import dev.shortloop.common.models.data.AgentConfig;
import dev.shortloop.common.models.data.RegisteredApi;
import dev.shortloop.common.models.data.URI;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.experimental.FieldDefaults;

@FieldDefaults(makeFinal = true, level = AccessLevel.PRIVATE)
@RequiredArgsConstructor
@Getter
@Setter
public class ObservedApi {
    URI uri;
    ShortloopCommonConstant.HttpRequestMethod method;

    public ObservedApi(String uriPath, ShortloopCommonConstant.HttpRequestMethod method) {
        this.uri = URI.getNonTemplatedURI(uriPath);
        this.method = method;
    }

    public boolean matches(AgentConfig.ApiConfig apiConfig) {
        if (apiConfig == null) {
            return false;
        }

        if (this.method != apiConfig.getMethod()) {
            return false;
        }
        return this.uri.equals(apiConfig.getUri());
    }

}
