/*
 * Decompiled with CFR 0.152.
 */
package dev.tinyflow.core.node;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.node.BaseNode;
import com.agentsflex.core.document.Document;
import com.agentsflex.core.prompt.template.TextPromptTemplate;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.StringUtil;
import dev.tinyflow.core.searchengine.SearchEngine;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchEngineNode
extends BaseNode {
    private static final Logger logger = LoggerFactory.getLogger(SearchEngineNode.class);
    private String engine;
    private SearchEngine searchEngine;
    private String limit;
    private String keyword;

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    public void setSearchEngine(SearchEngine searchEngine) {
        this.searchEngine = searchEngine;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    protected Map<String, Object> execute(Chain chain) {
        Map argsMap = chain.getParameterValues((ChainNode)this);
        String realKeyword = TextPromptTemplate.create((String)this.keyword).formatToString(argsMap);
        String realLimitString = TextPromptTemplate.create((String)this.limit).formatToString(argsMap);
        int realLimit = 10;
        if (StringUtil.hasText((String)realLimitString)) {
            try {
                realLimit = Integer.parseInt(realLimitString);
            }
            catch (Exception e) {
                logger.error(e.toString(), (Throwable)e);
            }
        }
        if (this.searchEngine == null) {
            return Collections.emptyMap();
        }
        List<Document> result = this.searchEngine.search(realKeyword, realLimit, this, chain);
        return Maps.of((String)"documents", result);
    }

    public String toString() {
        return "SearchEngineNode{engine='" + this.engine + '\'' + ", searchEngine=" + this.searchEngine + ", limit='" + this.limit + '\'' + ", keyword='" + this.keyword + '\'' + ", description='" + this.description + '\'' + ", parameters=" + this.parameters + ", outputDefs=" + this.outputDefs + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", async=" + this.async + ", inwardEdges=" + this.inwardEdges + ", outwardEdges=" + this.outwardEdges + ", condition=" + this.condition + ", memory=" + this.memory + ", nodeStatus=" + this.nodeStatus + '}';
    }
}

