/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ConfigurationUtil {
    private ConfigurationUtil() {
    }

    public static Configuration toConfiguration(Element element) {
        DefaultConfiguration configuration = new DefaultConfiguration(element.getNodeName(), "dom-created");
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = attributes.item(i);
            String name = node.getNodeName();
            String value2 = node.getNodeValue();
            configuration.setAttribute(name, value2);
        }
        boolean flag = false;
        String content = "";
        NodeList nodes = element.getChildNodes();
        int count2 = nodes.getLength();
        for (int i = 0; i < count2; ++i) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                Configuration child = ConfigurationUtil.toConfiguration((Element)node);
                configuration.addChild(child);
                continue;
            }
            if (!(node instanceof CharacterData)) continue;
            CharacterData data2 = (CharacterData)node;
            content = content + data2.getData();
            flag = true;
        }
        if (flag) {
            configuration.setValue(content);
        }
        return configuration;
    }

    public static Element toElement(Configuration configuration) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document2 = builder.newDocument();
            return ConfigurationUtil.createElement(document2, configuration);
        }
        catch (ParserConfigurationException pce) {
            throw new IllegalStateException(pce.toString());
        }
    }

    public static String toString(Configuration configuration) {
        DefaultConfigurationSerializer ser = new DefaultConfigurationSerializer();
        try {
            return ser.serialize(configuration);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static boolean equals(Configuration c1, Configuration c2) {
        return c1.getName().equals(c2.getName()) && ConfigurationUtil.areValuesEqual(c1, c2) && ConfigurationUtil.areAttributesEqual(c1, c2) && ConfigurationUtil.areChildrenEqual(c1, c2);
    }

    private static boolean areChildrenEqual(Configuration c1, Configuration c2) {
        ArrayList<Configuration> kids2;
        Configuration[] kids1 = c1.getChildren();
        if (kids1.length != (kids2 = new ArrayList<Configuration>(Arrays.asList(c2.getChildren()))).size()) {
            return false;
        }
        for (int i = 0; i < kids1.length; ++i) {
            if (ConfigurationUtil.findMatchingChild(kids1[i], kids2)) continue;
            return false;
        }
        return kids2.isEmpty();
    }

    private static boolean findMatchingChild(Configuration c, ArrayList matchAgainst) {
        Iterator i = matchAgainst.iterator();
        while (i.hasNext()) {
            if (!ConfigurationUtil.equals(c, (Configuration)i.next())) continue;
            i.remove();
            return true;
        }
        return false;
    }

    private static boolean areAttributesEqual(Configuration c1, Configuration c2) {
        String[] names2;
        String[] names1 = c1.getAttributeNames();
        if (names1.length != (names2 = c2.getAttributeNames()).length) {
            return false;
        }
        for (int i = 0; i < names1.length; ++i) {
            String value2;
            String name = names1[i];
            String value1 = c1.getAttribute(name, null);
            if (value1.equals(value2 = c2.getAttribute(name, null))) continue;
            return false;
        }
        return true;
    }

    private static boolean areValuesEqual(Configuration c1, Configuration c2) {
        String value1 = c1.getValue(null);
        String value2 = c2.getValue(null);
        return value1 == null && value2 == null || value1 != null && value1.equals(value2);
    }

    private static Element createElement(Document document2, Configuration configuration) {
        Element element = document2.createElement(configuration.getName());
        String content = configuration.getValue(null);
        if (null != content) {
            Text child = document2.createTextNode(content);
            element.appendChild(child);
        }
        String[] names = configuration.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String value2 = configuration.getAttribute(name, null);
            element.setAttribute(name, value2);
        }
        Configuration[] children2 = configuration.getChildren();
        for (int i = 0; i < children2.length; ++i) {
            Element child = ConfigurationUtil.createElement(document2, children2[i]);
            element.appendChild(child);
        }
        return element;
    }
}

