/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.avalon.framework.configuration.AbstractConfiguration;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.MutableConfiguration;

public class DefaultConfiguration
extends AbstractConfiguration
implements MutableConfiguration,
Serializable {
    protected static final Configuration[] EMPTY_ARRAY = new Configuration[0];
    private final String m_name;
    private final String m_location;
    private final String m_namespace;
    private final String m_prefix;
    private HashMap m_attributes;
    private ArrayList m_children;
    private String m_value;
    private boolean m_readOnly;

    public DefaultConfiguration(Configuration config, boolean deepCopy) throws ConfigurationException {
        this(config.getName(), config.getLocation(), config.getNamespace(), config instanceof AbstractConfiguration ? ((AbstractConfiguration)config).getPrefix() : "");
        this.addAll(config, deepCopy);
    }

    public DefaultConfiguration(Configuration config) throws ConfigurationException {
        this(config, false);
    }

    public DefaultConfiguration(String name) {
        this(name, null, "", "");
    }

    public DefaultConfiguration(String name, String location) {
        this(name, location, "", "");
    }

    public DefaultConfiguration(String name, String location, String ns, String prefix) {
        this.m_name = name;
        this.m_location = location;
        this.m_namespace = ns;
        this.m_prefix = prefix;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNamespace() throws ConfigurationException {
        if (null != this.m_namespace) {
            return this.m_namespace;
        }
        throw new ConfigurationException("No namespace (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    protected String getPrefix() throws ConfigurationException {
        if (null != this.m_prefix) {
            return this.m_prefix;
        }
        throw new ConfigurationException("No prefix (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getValue(String defaultValue) {
        if (null != this.m_value) {
            return this.m_value;
        }
        return defaultValue;
    }

    public String getValue() throws ConfigurationException {
        if (null != this.m_value) {
            return this.m_value;
        }
        throw new ConfigurationException("No value is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public String[] getAttributeNames() {
        if (null == this.m_attributes) {
            return new String[0];
        }
        return this.m_attributes.keySet().toArray(new String[0]);
    }

    public Configuration[] getChildren() {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        return this.m_children.toArray(new Configuration[0]);
    }

    public String getAttribute(String name) throws ConfigurationException {
        String value2;
        String string2 = value2 = null != this.m_attributes ? (String)this.m_attributes.get(name) : null;
        if (null != value2) {
            return value2;
        }
        throw new ConfigurationException("No attribute named \"" + name + "\" is " + "associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public Configuration getChild(String name, boolean createNew) {
        if (null != this.m_children) {
            int size2 = this.m_children.size();
            for (int i = 0; i < size2; ++i) {
                Configuration configuration = (Configuration)this.m_children.get(i);
                if (!name.equals(configuration.getName())) continue;
                return configuration;
            }
        }
        if (createNew) {
            return new DefaultConfiguration(name, "<generated>" + this.getLocation(), this.m_namespace, this.m_prefix);
        }
        return null;
    }

    public Configuration[] getChildren(String name) {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        ArrayList<Configuration> children2 = new ArrayList<Configuration>();
        int size2 = this.m_children.size();
        for (int i = 0; i < size2; ++i) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            if (!name.equals(configuration.getName())) continue;
            children2.add(configuration);
        }
        return children2.toArray(new Configuration[0]);
    }

    public void appendValueData(String value2) {
        this.checkWriteable();
        this.m_value = null == this.m_value ? value2 : this.m_value + value2;
    }

    public void setValue(String value2) {
        this.checkWriteable();
        this.m_value = value2;
    }

    public void setValue(int value2) {
        this.setValue(String.valueOf(value2));
    }

    public void setValue(long value2) {
        this.setValue(String.valueOf(value2));
    }

    public void setValue(boolean value2) {
        this.setValue(String.valueOf(value2));
    }

    public void setValue(float value2) {
        this.setValue(String.valueOf(value2));
    }

    public void setValue(double value2) {
        this.setValue(String.valueOf(value2));
    }

    public void setAttribute(String name, String value2) {
        this.checkWriteable();
        if (null != value2) {
            if (null == this.m_attributes) {
                this.m_attributes = new HashMap();
            }
            this.m_attributes.put(name, value2);
        } else if (null != this.m_attributes) {
            this.m_attributes.remove(name);
        }
    }

    public void setAttribute(String name, int value2) {
        this.setAttribute(name, String.valueOf(value2));
    }

    public void setAttribute(String name, long value2) {
        this.setAttribute(name, String.valueOf(value2));
    }

    public void setAttribute(String name, boolean value2) {
        this.setAttribute(name, String.valueOf(value2));
    }

    public void setAttribute(String name, float value2) {
        this.setAttribute(name, String.valueOf(value2));
    }

    public void setAttribute(String name, double value2) {
        this.setAttribute(name, String.valueOf(value2));
    }

    public String addAttribute(String name, String value2) {
        this.checkWriteable();
        if (null == this.m_attributes) {
            this.m_attributes = new HashMap();
        }
        return this.m_attributes.put(name, value2);
    }

    public void addChild(Configuration configuration) {
        this.checkWriteable();
        if (null == this.m_children) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(configuration);
    }

    public void addAll(Configuration other, boolean deepCopy) throws ConfigurationException {
        this.checkWriteable();
        this.setValue(other.getValue(null));
        this.addAllAttributes(other);
        this.addAllChildren(other, deepCopy);
    }

    public void addAll(Configuration other) {
        this.checkWriteable();
        this.setValue(other.getValue(null));
        this.addAllAttributes(other);
        this.addAllChildren(other);
    }

    public void addAllAttributes(Configuration other) {
        this.checkWriteable();
        String[] attributes = other.getAttributeNames();
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i];
            String value2 = other.getAttribute(name, null);
            this.setAttribute(name, value2);
        }
    }

    public void addAllChildren(Configuration other, boolean deepCopy) throws ConfigurationException {
        this.checkWriteable();
        Configuration[] children2 = other.getChildren();
        for (int i = 0; i < children2.length; ++i) {
            if (deepCopy) {
                this.addChild(new DefaultConfiguration(children2[i], true));
                continue;
            }
            this.addChild(children2[i]);
        }
    }

    public void addAllChildren(Configuration other) {
        this.checkWriteable();
        Configuration[] children2 = other.getChildren();
        for (int i = 0; i < children2.length; ++i) {
            this.addChild(children2[i]);
        }
    }

    public void removeChild(Configuration configuration) {
        this.checkWriteable();
        if (null == this.m_children) {
            return;
        }
        this.m_children.remove(configuration);
    }

    public int getChildCount() {
        if (null == this.m_children) {
            return 0;
        }
        return this.m_children.size();
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("Configuration is read only and can not be modified");
        }
    }

    protected final boolean isReadOnly() {
        return this.m_readOnly;
    }

    private MutableConfiguration toMutable(Configuration child) throws ConfigurationException {
        if (!(!(child instanceof MutableConfiguration) || child instanceof DefaultConfiguration && ((DefaultConfiguration)child).isReadOnly())) {
            return (MutableConfiguration)child;
        }
        this.checkWriteable();
        DefaultConfiguration config = new DefaultConfiguration(child);
        for (int i = 0; i < this.m_children.size(); ++i) {
            if (this.m_children.get(i) != child) continue;
            this.m_children.set(i, config);
            break;
        }
        return config;
    }

    public MutableConfiguration getMutableChild(String name) throws ConfigurationException {
        return this.getMutableChild(name, true);
    }

    public MutableConfiguration getMutableChild(String name, boolean autoCreate) throws ConfigurationException {
        Configuration child = this.getChild(name, false);
        if (child == null) {
            if (autoCreate) {
                DefaultConfiguration config = new DefaultConfiguration(name, "-");
                this.addChild(config);
                return config;
            }
            return null;
        }
        return this.toMutable(child);
    }

    public MutableConfiguration[] getMutableChildren() throws ConfigurationException {
        if (null == this.m_children) {
            return new MutableConfiguration[0];
        }
        ArrayList<MutableConfiguration> children2 = new ArrayList<MutableConfiguration>();
        int size2 = this.m_children.size();
        for (int i = 0; i < size2; ++i) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            children2.add(this.toMutable(configuration));
        }
        return children2.toArray(new MutableConfiguration[0]);
    }

    public MutableConfiguration[] getMutableChildren(String name) throws ConfigurationException {
        if (null == this.m_children) {
            return new MutableConfiguration[0];
        }
        ArrayList<MutableConfiguration> children2 = new ArrayList<MutableConfiguration>();
        int size2 = this.m_children.size();
        for (int i = 0; i < size2; ++i) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            if (!name.equals(configuration.getName())) continue;
            children2.add(this.toMutable(configuration));
        }
        return children2.toArray(new MutableConfiguration[0]);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof DefaultConfiguration)) {
            return false;
        }
        DefaultConfiguration c = (DefaultConfiguration)other;
        if (this.m_readOnly ^ c.m_readOnly) {
            return false;
        }
        if (this.check(this.m_name, c.m_name)) {
            return false;
        }
        if (this.check(this.m_location, c.m_location)) {
            return false;
        }
        if (this.check(this.m_namespace, c.m_namespace)) {
            return false;
        }
        if (this.check(this.m_prefix, c.m_prefix)) {
            return false;
        }
        if (this.check(this.m_value, c.m_value)) {
            return false;
        }
        if (this.check(this.m_attributes, c.m_attributes)) {
            return false;
        }
        return !this.check(this.m_children, c.m_children);
    }

    private boolean check(Object one, Object two) {
        if (one == null) {
            return two != null;
        }
        return !one.equals(two);
    }

    public int hashCode() {
        int hash2 = this.m_prefix.hashCode();
        if (this.m_name != null) {
            hash2 ^= this.m_name.hashCode();
        }
        hash2 >>>= 7;
        if (this.m_location != null) {
            hash2 ^= this.m_location.hashCode();
        }
        hash2 >>>= 7;
        if (this.m_namespace != null) {
            hash2 ^= this.m_namespace.hashCode();
        }
        hash2 >>>= 7;
        if (this.m_attributes != null) {
            hash2 ^= this.m_attributes.hashCode();
        }
        hash2 >>>= 7;
        if (this.m_children != null) {
            hash2 ^= this.m_children.hashCode();
        }
        hash2 >>>= 7;
        if (this.m_value != null) {
            hash2 ^= this.m_value.hashCode();
        }
        return hash2 >>>= this.m_readOnly ? 7 : 13;
    }
}

