/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableStringValue
extends AnimatableValue {
    protected String string;

    protected AnimatableStringValue(AnimationTarget target) {
        super(target);
    }

    public AnimatableStringValue(AnimationTarget target, String s2) {
        super(target);
        this.string = s2;
    }

    public AnimatableValue interpolate(AnimatableValue result2, AnimatableValue to2, float interpolation, AnimatableValue accumulation, int multiplier) {
        String newString;
        AnimatableStringValue res = result2 == null ? new AnimatableStringValue(this.target) : (AnimatableStringValue)result2;
        if (to2 != null && (double)interpolation >= 0.5) {
            AnimatableStringValue toValue = (AnimatableStringValue)to2;
            newString = toValue.string;
        } else {
            newString = this.string;
        }
        if (res.string == null || !res.string.equals(newString)) {
            res.string = newString;
            res.hasChanged = true;
        }
        return res;
    }

    public String getString() {
        return this.string;
    }

    public boolean canPace() {
        return false;
    }

    public float distanceTo(AnimatableValue other) {
        return 0.0f;
    }

    public AnimatableValue getZeroValue() {
        return new AnimatableStringValue(this.target, "");
    }

    public String getCssText() {
        return this.string;
    }
}

