/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.Serializable;

public class IntTable
implements Serializable {
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;

    public IntTable() {
        this.table = new Entry[11];
    }

    public IntTable(int c) {
        this.table = new Entry[c];
    }

    public IntTable(IntTable t) {
        this.count = t.count;
        this.table = new Entry[t.table.length];
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = t.table[i];
            Entry n = null;
            if (e == null) continue;
            this.table[i] = n = new Entry(e.hash, e.key, e.value, null);
            e = e.next;
            while (e != null) {
                n = n.next = new Entry(e.hash, e.key, e.value, null);
                e = e.next;
            }
        }
    }

    public int size() {
        return this.count;
    }

    protected Entry find(Object key) {
        return null;
    }

    public int get(Object key) {
        int hash2 = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index2 = hash2 % this.table.length;
        Entry e = this.table[index2];
        while (e != null) {
            if (e.hash == hash2 && (e.key == null && key == null || e.key != null && e.key.equals(key))) {
                return e.value;
            }
            e = e.next;
        }
        return 0;
    }

    public int put(Object key, int value2) {
        int hash2 = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index2 = hash2 % this.table.length;
        Entry e = this.table[index2];
        while (e != null) {
            if (e.hash == hash2 && (e.key == null && key == null || e.key != null && e.key.equals(key))) {
                int old = e.value;
                e.value = value2;
                return old;
            }
            e = e.next;
        }
        int len = this.table.length;
        if (this.count++ >= len - (len >> 2)) {
            this.rehash();
            index2 = hash2 % this.table.length;
        }
        this.table[index2] = new Entry(hash2, key, value2, this.table[index2]);
        return 0;
    }

    public int inc(Object key) {
        int hash2 = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index2 = hash2 % this.table.length;
        Entry e = this.table[index2];
        while (e != null) {
            if (e.hash == hash2 && (e.key == null && key == null || e.key != null && e.key.equals(key))) {
                return e.value++;
            }
            e = e.next;
        }
        int len = this.table.length;
        if (this.count++ >= len - (len >> 2)) {
            this.rehash();
            index2 = hash2 % this.table.length;
        }
        this.table[index2] = new Entry(hash2, key, 1, this.table[index2]);
        return 0;
    }

    public int dec(Object key) {
        int hash2 = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index2 = hash2 % this.table.length;
        Entry e = this.table[index2];
        while (e != null) {
            if (e.hash == hash2 && (e.key == null && key == null || e.key != null && e.key.equals(key))) {
                return e.value--;
            }
            e = e.next;
        }
        int len = this.table.length;
        if (this.count++ >= len - (len >> 2)) {
            this.rehash();
            index2 = hash2 % this.table.length;
        }
        this.table[index2] = new Entry(hash2, key, -1, this.table[index2]);
        return 0;
    }

    public int remove(Object key) {
        int hash2 = key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
        int index2 = hash2 % this.table.length;
        Entry p = null;
        Entry e = this.table[index2];
        while (e != null) {
            if (e.hash == hash2 && (e.key == null && key == null || e.key != null && e.key.equals(key))) {
                int result2 = e.value;
                if (p == null) {
                    this.table[index2] = e.next;
                } else {
                    p.next = e.next;
                }
                --this.count;
                return result2;
            }
            p = e;
            e = e.next;
        }
        return 0;
    }

    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.count = 0;
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        this.table = new Entry[oldTable.length * 2 + 1];
        for (int i = oldTable.length - 1; i >= 0; --i) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index2 = e.hash % this.table.length;
                e.next = this.table[index2];
                this.table[index2] = e;
            }
        }
    }

    protected static class Entry
    implements Serializable {
        public int hash;
        public Object key;
        public int value;
        public Entry next;

        public Entry(int hash2, Object key, int value2, Entry next2) {
            this.hash = hash2;
            this.key = key;
            this.value = value2;
            this.next = next2;
        }
    }
}

