/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

public class TriplyIndexedTable {
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;

    public TriplyIndexedTable() {
        this.table = new Entry[11];
    }

    public TriplyIndexedTable(int c) {
        this.table = new Entry[c];
    }

    public int size() {
        return this.count;
    }

    public Object put(Object o1, Object o2, Object o3, Object value2) {
        Entry e;
        int hash2 = this.hashCode(o1, o2, o3) & Integer.MAX_VALUE;
        int index2 = hash2 % this.table.length;
        Entry e2 = this.table[index2];
        while (e2 != null) {
            if (e2.hash == hash2 && e2.match(o1, o2, o3)) {
                Object old = e2.value;
                e2.value = value2;
                return old;
            }
            e2 = e2.next;
        }
        int len = this.table.length;
        if (this.count++ >= len - (len >> 2)) {
            this.rehash();
            index2 = hash2 % this.table.length;
        }
        this.table[index2] = e = new Entry(hash2, o1, o2, o3, value2, this.table[index2]);
        return null;
    }

    public Object get(Object o1, Object o2, Object o3) {
        int hash2 = this.hashCode(o1, o2, o3) & Integer.MAX_VALUE;
        int index2 = hash2 % this.table.length;
        Entry e = this.table[index2];
        while (e != null) {
            if (e.hash == hash2 && e.match(o1, o2, o3)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        this.table = new Entry[oldTable.length * 2 + 1];
        for (int i = oldTable.length - 1; i >= 0; --i) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index2 = e.hash % this.table.length;
                e.next = this.table[index2];
                this.table[index2] = e;
            }
        }
    }

    protected int hashCode(Object o1, Object o2, Object o3) {
        return (o1 == null ? 0 : o1.hashCode()) ^ (o2 == null ? 0 : o2.hashCode()) ^ (o3 == null ? 0 : o3.hashCode());
    }

    protected static class Entry {
        public int hash;
        public Object key1;
        public Object key2;
        public Object key3;
        public Object value;
        public Entry next;

        public Entry(int hash2, Object key1, Object key2, Object key3, Object value2, Entry next2) {
            this.hash = hash2;
            this.key1 = key1;
            this.key2 = key2;
            this.key3 = key3;
            this.value = value2;
            this.next = next2;
        }

        public boolean match(Object o1, Object o2, Object o3) {
            if (this.key1 != null ? !this.key1.equals(o1) : o1 != null) {
                return false;
            }
            if (this.key2 != null ? !this.key2.equals(o2) : o2 != null) {
                return false;
            }
            if (this.key3 != null) {
                return this.key3.equals(o3);
            }
            return o3 == null;
        }
    }
}

