/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.OutputStream;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final StringBuffer _lbuffer = new StringBuffer(8);
    private static final StringBuffer _cbuffer = new StringBuffer(2);
    private static final char[] _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] _shifts = new int[]{28, 24, 20, 16, 12, 8, 4, 0};

    public static void dump(byte[] data2, long offset, OutputStream stream, int index2) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (index2 < 0 || index2 >= data2.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + index2 + " into array of length " + data2.length);
        }
        if (stream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        long display_offset = offset + (long)index2;
        StringBuffer buffer = new StringBuffer(74);
        int j = index2;
        while (j < data2.length) {
            int chars_read = data2.length - j;
            if (chars_read > 16) {
                chars_read = 16;
            }
            buffer.append((Object)HexDump.dump(display_offset)).append(' ');
            int k = 0;
            while (k < 16) {
                if (k < chars_read) {
                    buffer.append((Object)HexDump.dump(data2[k + j]));
                } else {
                    buffer.append("  ");
                }
                buffer.append(' ');
                ++k;
            }
            int k2 = 0;
            while (k2 < chars_read) {
                if (data2[k2 + j] >= 32 && data2[k2 + j] < 127) {
                    buffer.append((char)data2[k2 + j]);
                } else {
                    buffer.append('.');
                }
                ++k2;
            }
            buffer.append(EOL);
            stream.write(buffer.toString().getBytes());
            stream.flush();
            buffer.setLength(0);
            display_offset += (long)chars_read;
            j += 16;
        }
    }

    private static StringBuffer dump(long value2) {
        _lbuffer.setLength(0);
        int j = 0;
        while (j < 8) {
            _lbuffer.append(_hexcodes[(int)(value2 >> _shifts[j]) & 0xF]);
            ++j;
        }
        return _lbuffer;
    }

    private static StringBuffer dump(byte value2) {
        _cbuffer.setLength(0);
        int j = 0;
        while (j < 2) {
            _cbuffer.append(_hexcodes[value2 >> _shifts[j + 6] & 0xF]);
            ++j;
        }
        return _cbuffer;
    }
}

