/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.File;
import java.net.MalformedURLException;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.substitute.FontSubstitutions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontManager {
    public static final boolean DEFAULT_USE_CACHE = true;
    private String fontBase = null;
    private FontCache fontCache = null;
    private FontSubstitutions fontSubstitutions = null;
    private boolean enableBase14Kerning = false;
    private FontTriplet.Matcher referencedFontsMatcher;
    private boolean useCache = true;
    private File cacheFile;

    public void setFontBaseURL(String fontBase) throws MalformedURLException {
        this.fontBase = fontBase;
    }

    public String getFontBaseURL() {
        return this.fontBase;
    }

    public boolean isBase14KerningEnabled() {
        return this.enableBase14Kerning;
    }

    public void setBase14KerningEnabled(boolean value2) {
        this.enableBase14Kerning = value2;
    }

    public void setFontSubstitutions(FontSubstitutions substitutions) {
        this.fontSubstitutions = substitutions;
    }

    protected FontSubstitutions getFontSubstitutions() {
        if (this.fontSubstitutions == null) {
            this.fontSubstitutions = new FontSubstitutions();
        }
        return this.fontSubstitutions;
    }

    public void setCacheFile(File cacheFile) {
        this.cacheFile = cacheFile;
    }

    public File getCacheFile() {
        if (this.cacheFile != null) {
            return this.cacheFile;
        }
        return FontCache.getDefaultCacheFile(false);
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
        if (!useCache) {
            this.fontCache = null;
        }
    }

    public boolean useCache() {
        return this.useCache;
    }

    public FontCache getFontCache() {
        if (this.fontCache == null && this.useCache) {
            this.fontCache = this.cacheFile != null ? FontCache.loadFrom(this.cacheFile) : FontCache.load();
            if (this.fontCache == null) {
                this.fontCache = new FontCache();
            }
        }
        return this.fontCache;
    }

    public void saveCache() throws FOPException {
        if (this.useCache && this.fontCache != null && this.fontCache.hasChanged()) {
            if (this.cacheFile != null) {
                this.fontCache.saveTo(this.cacheFile);
            } else {
                this.fontCache.save();
            }
        }
    }

    public boolean deleteCache() {
        boolean deleted = false;
        if (this.useCache) {
            deleted = this.cacheFile != null ? this.cacheFile.delete() : FontCache.getDefaultCacheFile(true).delete();
        }
        return deleted;
    }

    public void setup(FontInfo fontInfo, FontCollection[] fontCollections) {
        int startNum = 1;
        int c = fontCollections.length;
        for (int i = 0; i < c; ++i) {
            startNum = fontCollections[i].setup(startNum, fontInfo);
        }
        this.getFontSubstitutions().adjustFontInfo(fontInfo);
    }

    public static FontResolver createMinimalFontResolver(boolean useComplexScriptFeatures) {
        return new MinimalFontResolver(useComplexScriptFeatures);
    }

    public void setReferencedFontsMatcher(FontTriplet.Matcher matcher) {
        this.referencedFontsMatcher = matcher;
    }

    public FontTriplet.Matcher getReferencedFontsMatcher() {
        return this.referencedFontsMatcher;
    }

    public void updateReferencedFonts(List<EmbedFontInfo> fontInfoList) {
        FontTriplet.Matcher matcher = this.getReferencedFontsMatcher();
        this.updateReferencedFonts(fontInfoList, matcher);
    }

    public void updateReferencedFonts(List<EmbedFontInfo> fontInfoList, FontTriplet.Matcher matcher) {
        if (matcher == null) {
            return;
        }
        block0: for (EmbedFontInfo fontInfo : fontInfoList) {
            for (FontTriplet triplet : fontInfo.getFontTriplets()) {
                if (!matcher.matches(triplet)) continue;
                fontInfo.setEmbedded(false);
                continue block0;
            }
        }
    }

    public static class MinimalFontResolver
    implements FontResolver {
        private boolean useComplexScriptFeatures;

        MinimalFontResolver(boolean useComplexScriptFeatures) {
            this.useComplexScriptFeatures = useComplexScriptFeatures;
        }

        public Source resolve(String href) {
            return new StreamSource(href);
        }

        public boolean isComplexScriptFeaturesEnabled() {
            return this.useComplexScriptFeatures;
        }
    }
}

