/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.Resolvable;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fo.flow.AbstractPageNumberCitation;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;

public abstract class AbstractPageNumberCitationLayoutManager
extends LeafNodeLayoutManager {
    protected AbstractPageNumberCitation fobj;
    protected Font font;
    protected boolean resolved = false;

    public AbstractPageNumberCitationLayoutManager(AbstractPageNumberCitation node) {
        super(node);
        this.fobj = node;
    }

    public void initialize() {
        FontInfo fi = this.fobj.getFOEventHandler().getFontInfo();
        FontTriplet[] fontkeys = this.fobj.getCommonFont().getFontState(fi);
        this.font = fi.getFontInstance(fontkeys[0], this.fobj.getCommonFont().fontSize.getValue(this));
        this.setCommonBorderPaddingBackground(this.fobj.getCommonBorderPaddingBackground());
    }

    protected AlignmentContext makeAlignmentContext(LayoutContext context) {
        return new AlignmentContext(this.font, this.fobj.getLineHeight().getOptimum(this).getLength().getValue(this), this.fobj.getAlignmentAdjust(), this.fobj.getAlignmentBaseline(), this.fobj.getBaselineShift(), this.fobj.getDominantBaseline(), context.getAlignmentContext());
    }

    public abstract InlineArea get(LayoutContext var1);

    public void addAreas(PositionIterator posIter, LayoutContext context) {
        super.addAreas(posIter, context);
        if (!this.resolved) {
            this.getPSLM().addUnresolvedArea(this.fobj.getRefId(), (Resolvable)((Object)this.curArea));
        }
    }

    protected void updateTextAreaTraits(TextArea text2) {
        TraitSetter.setProducerID(text2, this.fobj.getId());
        text2.setBPD(this.font.getAscender() - this.font.getDescender());
        text2.setBaselineOffset(this.font.getAscender());
        TraitSetter.addFontTraits(text2, this.font);
        text2.addTrait(Trait.COLOR, this.fobj.getColor());
        TraitSetter.addStructureTreeElement(text2, this.fobj.getStructureTreeElement());
        TraitSetter.addTextDecoration(text2, this.fobj.getTextDecoration());
    }

    protected int getStringWidth(String str) {
        int width = 0;
        for (int count2 = 0; count2 < str.length(); ++count2) {
            width += this.font.getCharWidth(str.charAt(count2));
        }
        return width;
    }

    protected int getBidiLevel() {
        return this.fobj.getBidiLevel();
    }
}

