/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.util.AbstractPaintingState;
import org.apache.xmlgraphics.java2d.color.ColorUtil;

public class PDFPaintingState
extends AbstractPaintingState {
    private static final long serialVersionUID = 5384726143906371279L;

    public boolean setPaint(Paint p) {
        PDFData data2 = this.getPDFData();
        Paint currentPaint = data2.paint;
        if (currentPaint == null) {
            if (p != null) {
                data2.paint = p;
                return true;
            }
        } else if (p instanceof Color && currentPaint instanceof Color) {
            if (!ColorUtil.isSameColor((Color)p, (Color)currentPaint)) {
                data2.paint = p;
                return true;
            }
        } else if (!currentPaint.equals(p)) {
            data2.paint = p;
            return true;
        }
        return false;
    }

    public boolean checkClip(Shape cl) {
        Shape clip = this.getPDFData().clip;
        return clip == null ? cl != null : !new Area(clip).equals(new Area(cl));
    }

    public void setClip(Shape cl) {
        PDFData data2 = this.getPDFData();
        Shape clip = data2.clip;
        if (clip != null) {
            Area newClip = new Area(clip);
            newClip.intersect(new Area(cl));
            data2.clip = new GeneralPath(newClip);
        } else {
            data2.clip = cl;
        }
    }

    public boolean setCharacterSpacing(float value2) {
        PDFData data2 = this.getPDFData();
        if (value2 != data2.characterSpacing) {
            data2.characterSpacing = value2;
            return true;
        }
        return false;
    }

    public float getCharacterSpacing() {
        return this.getPDFData().characterSpacing;
    }

    public int getStackLevel() {
        return this.getStateStack().size();
    }

    public PDFGState getGState() {
        PDFGState defaultState = PDFGState.DEFAULT;
        PDFGState newState = new PDFGState();
        newState.addValues(defaultState);
        for (PDFData data2 : this.getStateStack()) {
            PDFGState state = data2.gstate;
            if (state == null) continue;
            newState.addValues(state);
        }
        if (this.getPDFData().gstate != null) {
            newState.addValues(this.getPDFData().gstate);
        }
        return newState;
    }

    protected AbstractPaintingState.AbstractData instantiateData() {
        return new PDFData();
    }

    protected AbstractPaintingState instantiate() {
        return new PDFPaintingState();
    }

    public void save() {
        AbstractPaintingState.AbstractData data2 = this.getData();
        AbstractPaintingState.AbstractData copy = (AbstractPaintingState.AbstractData)data2.clone();
        data2.clearTransform();
        this.getStateStack().add(copy);
    }

    private PDFData getPDFData() {
        return (PDFData)this.getData();
    }

    private class PDFData
    extends AbstractPaintingState.AbstractData {
        private static final long serialVersionUID = 3527950647293177764L;
        private Paint paint;
        private Paint backPaint;
        private Shape clip;
        private PDFGState gstate;
        private float characterSpacing;

        private PDFData() {
            super(PDFPaintingState.this);
            this.paint = null;
            this.backPaint = null;
            this.clip = null;
            this.gstate = null;
            this.characterSpacing = 0.0f;
        }

        public Object clone() {
            PDFData obj = (PDFData)super.clone();
            obj.paint = this.paint;
            obj.backPaint = this.paint;
            obj.clip = this.clip;
            obj.gstate = this.gstate;
            obj.characterSpacing = this.characterSpacing;
            return obj;
        }

        public String toString() {
            return super.toString() + ", paint=" + this.paint + ", backPaint=" + this.backPaint + ", clip=" + this.clip + ", gstate=" + this.gstate;
        }

        protected AbstractPaintingState.AbstractData instantiate() {
            return new PDFData();
        }
    }
}

