/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.tools;

public final class ImageUtil {
    private ImageUtil() {
    }

    public static int getInt(String value2) {
        String retString = new String();
        StringBuffer s2 = new StringBuffer(value2);
        int len = s2.length();
        for (int i = 0; i < len && Character.isDigit(s2.charAt(i)); ++i) {
            retString = retString + s2.charAt(i);
        }
        if (retString.length() == 0) {
            return -1;
        }
        return Integer.parseInt(retString);
    }

    public static boolean isPercent(String value2) {
        return value2.endsWith("%");
    }

    public static boolean compareHexValues(byte[] pattern, byte[] data2, int searchAt, boolean searchForward) {
        if (searchAt >= data2.length) {
            return false;
        }
        int pLen = pattern.length;
        if (searchForward) {
            if (pLen >= data2.length - searchAt) {
                return false;
            }
            for (int i = 0; i < pLen; ++i) {
                if (pattern[i] == data2[searchAt + i]) continue;
                return false;
            }
            return true;
        }
        if (pLen > searchAt + 1) {
            return false;
        }
        for (int i = 0; i < pLen; ++i) {
            if (pattern[pLen - i - 1] == data2[searchAt - i]) continue;
            return false;
        }
        return true;
    }

    public static int getIntFromByteArray(byte[] data2, int startAt, int length, boolean searchForward) {
        int bit = 8;
        int bitMoving = length * bit;
        int retVal = 0;
        if (startAt >= data2.length) {
            return retVal;
        }
        if (searchForward) {
            if (length >= data2.length - startAt) {
                return retVal;
            }
            for (int i = 0; i < length; ++i) {
                bitMoving -= bit;
                int iData = data2[startAt + i];
                if (iData < 0) {
                    iData += 256;
                }
                retVal += iData << bitMoving;
            }
        } else {
            if (length > startAt + 1) {
                return retVal;
            }
            for (int i = 0; i < length; ++i) {
                bitMoving -= bit;
                int iData = data2[startAt - i];
                if (iData < 0) {
                    iData += 256;
                }
                retVal += iData << bitMoving;
            }
        }
        return retVal;
    }
}

