/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class SuballocatedIntVector {
    protected int m_blocksize;
    protected int m_SHIFT = 0;
    protected int m_MASK;
    protected static final int NUMBLOCKS_DEFAULT = 32;
    protected int m_numblocks = 32;
    protected int[][] m_map;
    protected int m_firstFree = 0;
    protected int[] m_map0;
    protected int[] m_buildCache;
    protected int m_buildCacheStartIndex;

    public SuballocatedIntVector() {
        this(2048);
    }

    public SuballocatedIntVector(int blocksize, int numblocks) {
        while (0 != (blocksize >>>= 1)) {
            ++this.m_SHIFT;
        }
        this.m_blocksize = 1 << this.m_SHIFT;
        this.m_MASK = this.m_blocksize - 1;
        this.m_numblocks = numblocks;
        this.m_map0 = new int[this.m_blocksize];
        this.m_map = new int[numblocks][];
        this.m_map[0] = this.m_map0;
        this.m_buildCache = this.m_map0;
        this.m_buildCacheStartIndex = 0;
    }

    public SuballocatedIntVector(int blocksize) {
        this(blocksize, 32);
    }

    public int size() {
        return this.m_firstFree;
    }

    public void setSize(int sz) {
        if (this.m_firstFree > sz) {
            this.m_firstFree = sz;
        }
    }

    public void addElement(int value2) {
        int indexRelativeToCache = this.m_firstFree - this.m_buildCacheStartIndex;
        if (indexRelativeToCache >= 0 && indexRelativeToCache < this.m_blocksize) {
            this.m_buildCache[indexRelativeToCache] = value2;
            ++this.m_firstFree;
        } else {
            int[] block;
            int index2 = this.m_firstFree >>> this.m_SHIFT;
            int offset = this.m_firstFree & this.m_MASK;
            if (index2 >= this.m_map.length) {
                int newsize = index2 + this.m_numblocks;
                int[][] newMap = new int[newsize][];
                System.arraycopy(this.m_map, 0, newMap, 0, this.m_map.length);
                this.m_map = newMap;
            }
            if (null == (block = this.m_map[index2])) {
                this.m_map[index2] = new int[this.m_blocksize];
                block = this.m_map[index2];
            }
            block[offset] = value2;
            this.m_buildCache = block;
            this.m_buildCacheStartIndex = this.m_firstFree - offset;
            ++this.m_firstFree;
        }
    }

    private void addElements(int value2, int numberOfElements) {
        if (this.m_firstFree + numberOfElements < this.m_blocksize) {
            int i = 0;
            while (i < numberOfElements) {
                this.m_map0[this.m_firstFree++] = value2;
                ++i;
            }
        } else {
            int index2 = this.m_firstFree >>> this.m_SHIFT;
            int offset = this.m_firstFree & this.m_MASK;
            this.m_firstFree += numberOfElements;
            while (numberOfElements > 0) {
                int[] block;
                if (index2 >= this.m_map.length) {
                    int newsize = index2 + this.m_numblocks;
                    int[][] newMap = new int[newsize][];
                    System.arraycopy(this.m_map, 0, newMap, 0, this.m_map.length);
                    this.m_map = newMap;
                }
                if (null == (block = this.m_map[index2])) {
                    this.m_map[index2] = new int[this.m_blocksize];
                    block = this.m_map[index2];
                }
                int copied = this.m_blocksize - offset < numberOfElements ? this.m_blocksize - offset : numberOfElements;
                numberOfElements -= copied;
                while (copied-- > 0) {
                    block[offset++] = value2;
                }
                ++index2;
                offset = 0;
            }
        }
    }

    private void addElements(int numberOfElements) {
        int newlen = this.m_firstFree + numberOfElements;
        if (newlen > this.m_blocksize) {
            int index2 = this.m_firstFree >>> this.m_SHIFT;
            int newindex = this.m_firstFree + numberOfElements >>> this.m_SHIFT;
            int i = index2 + 1;
            while (i <= newindex) {
                this.m_map[i] = new int[this.m_blocksize];
                ++i;
            }
        }
        this.m_firstFree = newlen;
    }

    private void insertElementAt(int value2, int at) {
        if (at == this.m_firstFree) {
            this.addElement(value2);
        } else if (at > this.m_firstFree) {
            int[] block;
            int index2 = at >>> this.m_SHIFT;
            if (index2 >= this.m_map.length) {
                int newsize = index2 + this.m_numblocks;
                int[][] newMap = new int[newsize][];
                System.arraycopy(this.m_map, 0, newMap, 0, this.m_map.length);
                this.m_map = newMap;
            }
            if (null == (block = this.m_map[index2])) {
                this.m_map[index2] = new int[this.m_blocksize];
                block = this.m_map[index2];
            }
            int offset = at & this.m_MASK;
            block[offset] = value2;
            this.m_firstFree = offset + 1;
        } else {
            int index3 = at >>> this.m_SHIFT;
            int maxindex = this.m_firstFree >>> this.m_SHIFT;
            ++this.m_firstFree;
            int offset = at & this.m_MASK;
            while (index3 <= maxindex) {
                int push;
                int copylen = this.m_blocksize - offset - 1;
                int[] block = this.m_map[index3];
                if (null == block) {
                    push = 0;
                    this.m_map[index3] = new int[this.m_blocksize];
                    block = this.m_map[index3];
                } else {
                    push = block[this.m_blocksize - 1];
                    System.arraycopy(block, offset, block, offset + 1, copylen);
                }
                block[offset] = value2;
                value2 = push;
                offset = 0;
                ++index3;
            }
        }
    }

    public void removeAllElements() {
        this.m_firstFree = 0;
        this.m_buildCache = this.m_map0;
        this.m_buildCacheStartIndex = 0;
    }

    private boolean removeElement(int s2) {
        int at = this.indexOf(s2, 0);
        if (at < 0) {
            return false;
        }
        this.removeElementAt(at);
        return true;
    }

    private void removeElementAt(int at) {
        if (at < this.m_firstFree) {
            int index2 = at >>> this.m_SHIFT;
            int maxindex = this.m_firstFree >>> this.m_SHIFT;
            int offset = at & this.m_MASK;
            while (index2 <= maxindex) {
                int copylen = this.m_blocksize - offset - 1;
                int[] block = this.m_map[index2];
                if (null == block) {
                    this.m_map[index2] = new int[this.m_blocksize];
                    block = this.m_map[index2];
                } else {
                    System.arraycopy(block, offset + 1, block, offset, copylen);
                }
                if (index2 < maxindex) {
                    int[] next2 = this.m_map[index2 + 1];
                    if (next2 != null) {
                        block[this.m_blocksize - 1] = next2 != null ? next2[0] : 0;
                    }
                } else {
                    block[this.m_blocksize - 1] = 0;
                }
                offset = 0;
                ++index2;
            }
        }
        --this.m_firstFree;
    }

    public void setElementAt(int value2, int at) {
        if (at < this.m_blocksize) {
            this.m_map0[at] = value2;
        } else {
            int[] block;
            int index2 = at >>> this.m_SHIFT;
            int offset = at & this.m_MASK;
            if (index2 >= this.m_map.length) {
                int newsize = index2 + this.m_numblocks;
                int[][] newMap = new int[newsize][];
                System.arraycopy(this.m_map, 0, newMap, 0, this.m_map.length);
                this.m_map = newMap;
            }
            if (null == (block = this.m_map[index2])) {
                this.m_map[index2] = new int[this.m_blocksize];
                block = this.m_map[index2];
            }
            block[offset] = value2;
        }
        if (at >= this.m_firstFree) {
            this.m_firstFree = at + 1;
        }
    }

    public int elementAt(int i) {
        if (i < this.m_blocksize) {
            return this.m_map0[i];
        }
        return this.m_map[i >>> this.m_SHIFT][i & this.m_MASK];
    }

    private boolean contains(int s2) {
        return this.indexOf(s2, 0) >= 0;
    }

    public int indexOf(int elem2, int index2) {
        int[] block;
        if (index2 >= this.m_firstFree) {
            return -1;
        }
        int bindex = index2 >>> this.m_SHIFT;
        int boffset = index2 & this.m_MASK;
        int maxindex = this.m_firstFree >>> this.m_SHIFT;
        while (bindex < maxindex) {
            block = this.m_map[bindex];
            if (block != null) {
                int offset = boffset;
                while (offset < this.m_blocksize) {
                    if (block[offset] == elem2) {
                        return offset + bindex * this.m_blocksize;
                    }
                    ++offset;
                }
            }
            boffset = 0;
            ++bindex;
        }
        int maxoffset = this.m_firstFree & this.m_MASK;
        block = this.m_map[maxindex];
        int offset = boffset;
        while (offset < maxoffset) {
            if (block[offset] == elem2) {
                return offset + maxindex * this.m_blocksize;
            }
            ++offset;
        }
        return -1;
    }

    public int indexOf(int elem2) {
        return this.indexOf(elem2, 0);
    }

    private int lastIndexOf(int elem2) {
        int boffset = this.m_firstFree & this.m_MASK;
        int index2 = this.m_firstFree >>> this.m_SHIFT;
        while (index2 >= 0) {
            int[] block = this.m_map[index2];
            if (block != null) {
                int offset = boffset;
                while (offset >= 0) {
                    if (block[offset] == elem2) {
                        return offset + index2 * this.m_blocksize;
                    }
                    --offset;
                }
            }
            boffset = 0;
            --index2;
        }
        return -1;
    }

    public final int[] getMap0() {
        return this.m_map0;
    }

    public final int[][] getMap() {
        return this.m_map;
    }
}

