/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.util.ArrayList;
import org.gedcom4j.model.StringWithCustomTags;
import org.gedcom4j.model.Submitter;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.AddressValidator;
import org.gedcom4j.validate.GedcomValidator;
import org.gedcom4j.validate.NotesValidator;

class SubmitterValidator
extends AbstractValidator {
    private final Submitter submitter;

    public SubmitterValidator(GedcomValidator rootValidator, Submitter submitter) {
        this.rootValidator = rootValidator;
        this.submitter = submitter;
    }

    private void checkLanguagePreferences() {
        if (this.submitter.languagePref == null) {
            if (this.rootValidator.autorepair) {
                this.submitter.languagePref = new ArrayList<StringWithCustomTags>();
                this.addInfo("Submitter language preference collection was null - autorepaired", this.submitter);
            } else {
                this.addInfo("Submitter language preference collection is null", this.submitter);
            }
        } else {
            if (this.submitter.languagePref.size() > 3) {
                this.addError("Submitter exceeds limit on language preferences (3)", this.submitter);
            }
            for (StringWithCustomTags s2 : this.submitter.languagePref) {
                this.checkRequiredString(s2, "language pref", (Object)this.submitter);
            }
        }
    }

    protected void validate() {
        if (this.submitter == null) {
            this.addError("Submitter being validated is null");
            return;
        }
        this.checkXref(this.submitter);
        this.checkRequiredString(this.submitter.name, "name", (Object)this.submitter);
        this.checkLanguagePreferences();
        this.checkOptionalString(this.submitter.recIdNumber, "record id number", (Object)this.submitter);
        this.checkOptionalString(this.submitter.regFileNumber, "submitter registered rfn", (Object)this.submitter);
        if (this.submitter.address != null) {
            new AddressValidator(this.rootValidator, this.submitter.address).validate();
        }
        new NotesValidator(this.rootValidator, this.submitter, this.submitter.notes).validate();
    }
}

