/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.serialize;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

public class ScriptableOutputStream
extends ObjectOutputStream {
    private Scriptable scope;
    private Hashtable table;

    public ScriptableOutputStream(OutputStream outputStream, Scriptable scriptable) throws IOException {
        super(outputStream);
        this.scope = scriptable;
        this.table = new Hashtable(31);
        this.table.put(scriptable, "");
        this.enableReplaceObject(true);
        this.excludeStandardObjectNames();
    }

    public void addOptionalExcludedName(String string2) {
        Object object = ScriptableOutputStream.lookupQualifiedName(this.scope, string2);
        if (object != null && object != UniqueTag.NOT_FOUND) {
            if (!(object instanceof Scriptable)) {
                throw new IllegalArgumentException("Object for excluded name " + string2 + " is not a Scriptable, it is " + object.getClass().getName());
            }
            this.table.put(object, string2);
        }
    }

    public void addExcludedName(String string2) {
        Object object = ScriptableOutputStream.lookupQualifiedName(this.scope, string2);
        if (!(object instanceof Scriptable)) {
            throw new IllegalArgumentException("Object for excluded name " + string2 + " not found.");
        }
        this.table.put(object, string2);
    }

    public boolean hasExcludedName(String string2) {
        return this.table.get(string2) != null;
    }

    public void removeExcludedName(String string2) {
        this.table.remove(string2);
    }

    public void excludeStandardObjectNames() {
        String[] stringArray = new String[]{"Object", "Object.prototype", "Function", "Function.prototype", "String", "String.prototype", "Math", "Array", "Array.prototype", "Error", "Error.prototype", "Number", "Number.prototype", "Date", "Date.prototype", "RegExp", "RegExp.prototype", "Script", "Script.prototype", "Continuation", "Continuation.prototype"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.addExcludedName(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"XML", "XML.prototype", "XMLList", "XMLList.prototype"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.addOptionalExcludedName(stringArray2[i]);
        }
    }

    static Object lookupQualifiedName(Scriptable scriptable, String string2) {
        String string3;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        Object object = scriptable;
        while (stringTokenizer.hasMoreTokens() && (object = ScriptableObject.getProperty((Scriptable)object, string3 = stringTokenizer.nextToken())) != null && object instanceof Scriptable) {
        }
        return object;
    }

    protected Object replaceObject(Object object) throws IOException {
        String string2 = (String)this.table.get(object);
        if (string2 == null) {
            return object;
        }
        return new PendingLookup(string2);
    }

    static class PendingLookup
    implements Serializable {
        static final long serialVersionUID = -2692990309789917727L;
        private String name;

        PendingLookup(String string2) {
            this.name = string2;
        }

        String getName() {
            return this.name;
        }
    }
}

