/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemodder.codetf.CodeTFValidator;
import java.util.Objects;

public final class CodeTFPackageAction {
    private final String packageUrl;
    private final CodeTFPackageActionResult result;
    private final CodeTFPackageActionType action;

    @JsonCreator
    public CodeTFPackageAction(@JsonProperty(value="action") CodeTFPackageActionType action, @JsonProperty(value="result") CodeTFPackageActionResult result, @JsonProperty(value="package") String packageUrl) {
        this.packageUrl = CodeTFValidator.requireNonBlank(packageUrl);
        this.result = Objects.requireNonNull(result);
        this.action = Objects.requireNonNull(action);
    }

    public String getPackage() {
        return this.packageUrl;
    }

    public CodeTFPackageActionResult getResult() {
        return this.result;
    }

    public CodeTFPackageActionType getAction() {
        return this.action;
    }

    public static enum CodeTFPackageActionResult {
        COMPLETED,
        FAILED,
        SKIPPED;

    }

    public static enum CodeTFPackageActionType {
        ADD,
        REMOVE;

    }
}

