/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import io.intercom.api.AdminAwayMode;
import io.intercom.api.AdminCollection;
import io.intercom.api.AuthorizationException;
import io.intercom.api.Avatar;
import io.intercom.api.ClientException;
import io.intercom.api.DataResource;
import io.intercom.api.HttpClient;
import io.intercom.api.InvalidException;
import io.intercom.api.RateLimitException;
import io.intercom.api.Replier;
import io.intercom.api.ServerException;
import io.intercom.api.TypedData;
import io.intercom.api.UriBuilder;
import java.net.URI;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Admin
extends TypedData
implements Replier {
    private static final Map<String, String> SENTINEL = Maps.newHashMap();
    public static final String TYPE_NOBODY = "nobody_admin";
    @JsonProperty(value="type")
    private String type = "admin";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonProperty(value="open")
    private long open;
    @JsonProperty(value="closed")
    private long closed;
    @JsonProperty(value="away_mode_enabled")
    private boolean awayModeEnabled;
    @JsonProperty(value="away_mode_reassign")
    private boolean awayModeReassign;
    @JsonProperty(value="has_inbox_seat")
    private boolean hasInboxSeat;
    @JsonProperty(value="avatar")
    private Avatar avatar;
    @JsonProperty(value="team_ids")
    private List<String> teamIds;
    @JsonProperty(value="admin_ids")
    private List<String> adminIds;

    static AdminCollection list(Map<String, String> params) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.list(params, "admins", AdminCollection.class);
    }

    public static AdminCollection list() throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.list(SENTINEL, "admins", AdminCollection.class);
    }

    public static Admin find(String id) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        HttpClient resource = new HttpClient(UriBuilder.newBuilder().path("admins").path(id).build());
        return resource.get(Admin.class);
    }

    public static Admin setAwayMode(String id, boolean away_mode_enabled, boolean away_mode_reassign) {
        URI uri = UriBuilder.newBuilder().path("admins").path(id).path("away").build();
        return new HttpClient(uri).put(Admin.class, new AdminAwayMode(id, away_mode_enabled, away_mode_reassign));
    }

    @Override
    @JsonIgnore
    public String getReplyType() {
        return this.getType() + "_reply";
    }

    @Override
    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public boolean isNobody() {
        return TYPE_NOBODY.equalsIgnoreCase(this.getType());
    }

    @JsonIgnore
    public boolean isSomebody() {
        return !this.isNobody() && this.getId() != null;
    }

    public String getId() {
        return this.id;
    }

    public Admin setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public long getOpen() {
        return this.open;
    }

    public long getClosed() {
        return this.closed;
    }

    public boolean getAwayModeEnabled() {
        return this.awayModeEnabled;
    }

    public boolean getAwayModeReassign() {
        return this.awayModeReassign;
    }

    public boolean getHasInboxSeat() {
        return this.hasInboxSeat;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public List getTeamIds() {
        return this.teamIds;
    }

    public List getAdminIds() {
        return this.adminIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Admin admin = (Admin)o;
        if (this.closed != admin.closed) {
            return false;
        }
        if (this.createdAt != admin.createdAt) {
            return false;
        }
        if (this.open != admin.open) {
            return false;
        }
        if (this.updatedAt != admin.updatedAt) {
            return false;
        }
        if (this.email != null ? !this.email.equals(admin.email) : admin.email != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(admin.id) : admin.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(admin.name) : admin.name != null) {
            return false;
        }
        if (this.awayModeEnabled != admin.awayModeEnabled) {
            return false;
        }
        if (this.awayModeReassign != admin.awayModeReassign) {
            return false;
        }
        if (this.avatar != null ? !this.avatar.equals(admin.avatar) : admin.avatar != null) {
            return false;
        }
        if (this.teamIds != null ? !this.teamIds.equals(admin.teamIds) : admin.teamIds != null) {
            return false;
        }
        if (this.adminIds != null ? !this.adminIds.equals(admin.adminIds) : admin.adminIds != null) {
            return false;
        }
        return this.type.equals(admin.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        result = 31 * result + (int)(this.open ^ this.open >>> 32);
        result = 31 * result + (int)(this.closed ^ this.closed >>> 32);
        result = 31 * result + (this.awayModeEnabled ? 1 : 0);
        result = 31 * result + (this.awayModeReassign ? 1 : 0);
        result = 31 * result + (this.avatar != null ? this.avatar.hashCode() : 0);
        result = 31 * result + (this.teamIds != null ? this.teamIds.hashCode() : 0);
        result = 31 * result + (this.adminIds != null ? this.adminIds.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Admin{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", email='" + this.email + '\'' + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", awayModeEnabled=" + this.awayModeEnabled + ", awayModeReassign=" + this.awayModeReassign + ", teamIds=" + this.teamIds + ", adminIds=" + this.adminIds + ", avatar=" + this.avatar + "} " + super.toString();
    }
}

