/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.articles.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FindArticleRequest.Builder.class)
public final class FindArticleRequest {
    private final int articleId;

    private final Map<String, Object> additionalProperties;

    private FindArticleRequest(int articleId, Map<String, Object> additionalProperties) {
        this.articleId = articleId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the article which is given by Intercom.
     */
    @JsonProperty("article_id")
    public int getArticleId() {
        return articleId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FindArticleRequest && equalTo((FindArticleRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FindArticleRequest other) {
        return articleId == other.articleId;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.articleId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ArticleIdStage builder() {
        return new Builder();
    }

    public interface ArticleIdStage {
        /**
         * <p>The unique identifier for the article which is given by Intercom.</p>
         */
        _FinalStage articleId(int articleId);

        Builder from(FindArticleRequest other);
    }

    public interface _FinalStage {
        FindArticleRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ArticleIdStage, _FinalStage {
        private int articleId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(FindArticleRequest other) {
            articleId(other.getArticleId());
            return this;
        }

        /**
         * <p>The unique identifier for the article which is given by Intercom.</p>
         * <p>The unique identifier for the article which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("article_id")
        public _FinalStage articleId(int articleId) {
            this.articleId = articleId;
            return this;
        }

        @java.lang.Override
        public FindArticleRequest build() {
            return new FindArticleRequest(articleId, additionalProperties);
        }
    }
}
