/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.internalarticles.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SearchInternalArticlesRequest.Builder.class)
public final class SearchInternalArticlesRequest {
    private final Optional<String> folderId;

    private final Map<String, Object> additionalProperties;

    private SearchInternalArticlesRequest(Optional<String> folderId, Map<String, Object> additionalProperties) {
        this.folderId = folderId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The ID of the folder to search in.
     */
    @JsonProperty("folder_id")
    public Optional<String> getFolderId() {
        return folderId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SearchInternalArticlesRequest && equalTo((SearchInternalArticlesRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchInternalArticlesRequest other) {
        return folderId.equals(other.folderId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.folderId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> folderId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(SearchInternalArticlesRequest other) {
            folderId(other.getFolderId());
            return this;
        }

        /**
         * <p>The ID of the folder to search in.</p>
         */
        @JsonSetter(value = "folder_id", nulls = Nulls.SKIP)
        public Builder folderId(Optional<String> folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder folderId(String folderId) {
            this.folderId = Optional.ofNullable(folderId);
            return this;
        }

        public SearchInternalArticlesRequest build() {
            return new SearchInternalArticlesRequest(folderId, additionalProperties);
        }
    }
}
