/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.subscriptiontypes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.types.SubscriptionTypeList;
import java.util.concurrent.CompletableFuture;

public class AsyncSubscriptionTypesClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawSubscriptionTypesClient rawClient;

    public AsyncSubscriptionTypesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawSubscriptionTypesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawSubscriptionTypesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can list all subscription types. A list of subscription type objects will be returned.
     */
    public CompletableFuture<SubscriptionTypeList> list() {
        return this.rawClient.list().thenApply(response -> response.body());
    }

    /**
     * You can list all subscription types. A list of subscription type objects will be returned.
     */
    public CompletableFuture<SubscriptionTypeList> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> response.body());
    }
}
