/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.admins;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.admins.requests.ListActivityLogsRequest;
import com.intercom.api.resources.unstable.admins.requests.RetrieveAdminRequest;
import com.intercom.api.resources.unstable.admins.requests.SetAwayAdminRequest;
import com.intercom.api.resources.unstable.admins.types.Admin;
import com.intercom.api.resources.unstable.types.ActivityLogList;
import com.intercom.api.resources.unstable.types.AdminList;
import com.intercom.api.resources.unstable.types.AdminWithApp;
import java.util.Optional;

public class AdminsClient {
    protected final ClientOptions clientOptions;

    private final RawAdminsClient rawClient;

    public AdminsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawAdminsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawAdminsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can view the currently authorised admin along with the embedded app object (a &quot;workspace&quot; in legacy terminology).
     * <blockquote>
     * <p>🚧 Single Sign On</p>
     * <p>If you are building a custom &quot;Log in with Intercom&quot; flow for your site, and you call the <code>/me</code> endpoint to identify the logged-in user, you should not accept any sign-ins from users with unverified email addresses as it poses a potential impersonation security risk.</p>
     * </blockquote>
     */
    public Optional<AdminWithApp> identifyAdmin() {
        return this.rawClient.identifyAdmin().body();
    }

    /**
     * You can view the currently authorised admin along with the embedded app object (a &quot;workspace&quot; in legacy terminology).
     * <blockquote>
     * <p>🚧 Single Sign On</p>
     * <p>If you are building a custom &quot;Log in with Intercom&quot; flow for your site, and you call the <code>/me</code> endpoint to identify the logged-in user, you should not accept any sign-ins from users with unverified email addresses as it poses a potential impersonation security risk.</p>
     * </blockquote>
     */
    public Optional<AdminWithApp> identifyAdmin(RequestOptions requestOptions) {
        return this.rawClient.identifyAdmin(requestOptions).body();
    }

    /**
     * You can set an Admin as away for the Inbox.
     */
    public Optional<Admin> setAwayAdmin(SetAwayAdminRequest request) {
        return this.rawClient.setAwayAdmin(request).body();
    }

    /**
     * You can set an Admin as away for the Inbox.
     */
    public Optional<Admin> setAwayAdmin(SetAwayAdminRequest request, RequestOptions requestOptions) {
        return this.rawClient.setAwayAdmin(request, requestOptions).body();
    }

    /**
     * You can get a log of activities by all admins in an app.
     */
    public ActivityLogList listActivityLogs(ListActivityLogsRequest request) {
        return this.rawClient.listActivityLogs(request).body();
    }

    /**
     * You can get a log of activities by all admins in an app.
     */
    public ActivityLogList listActivityLogs(ListActivityLogsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listActivityLogs(request, requestOptions).body();
    }

    /**
     * You can fetch a list of admins for a given workspace.
     */
    public AdminList listAdmins() {
        return this.rawClient.listAdmins().body();
    }

    /**
     * You can fetch a list of admins for a given workspace.
     */
    public AdminList listAdmins(RequestOptions requestOptions) {
        return this.rawClient.listAdmins(requestOptions).body();
    }

    /**
     * You can retrieve the details of a single admin.
     */
    public Optional<Admin> retrieveAdmin(RetrieveAdminRequest request) {
        return this.rawClient.retrieveAdmin(request).body();
    }

    /**
     * You can retrieve the details of a single admin.
     */
    public Optional<Admin> retrieveAdmin(RetrieveAdminRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveAdmin(request, requestOptions).body();
    }
}
