/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.articles;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.articles.requests.DeleteArticleRequest;
import com.intercom.api.resources.unstable.articles.requests.RetrieveArticleRequest;
import com.intercom.api.resources.unstable.articles.requests.SearchArticlesRequest;
import com.intercom.api.resources.unstable.articles.types.Article;
import com.intercom.api.resources.unstable.articles.types.ArticleSearchResponse;
import com.intercom.api.resources.unstable.types.ArticleList;
import com.intercom.api.resources.unstable.types.DeletedArticleObject;
import java.util.concurrent.CompletableFuture;

public class AsyncArticlesClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawArticlesClient rawClient;

    public AsyncArticlesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawArticlesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawArticlesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of all articles by making a GET request to <code>https://api.intercom.io/articles</code>.
     * <blockquote>
     * <p>📘 How are the articles sorted and ordered?</p>
     * <p>Articles will be returned in descending order on the <code>updated_at</code> attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.</p>
     * </blockquote>
     */
    public CompletableFuture<ArticleList> listArticles() {
        return this.rawClient.listArticles().thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all articles by making a GET request to <code>https://api.intercom.io/articles</code>.
     * <blockquote>
     * <p>📘 How are the articles sorted and ordered?</p>
     * <p>Articles will be returned in descending order on the <code>updated_at</code> attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.</p>
     * </blockquote>
     */
    public CompletableFuture<ArticleList> listArticles(RequestOptions requestOptions) {
        return this.rawClient.listArticles(requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can create a new article by making a POST request to <code>https://api.intercom.io/articles</code>.
     */
    public CompletableFuture<Article> createArticle(Object request) {
        return this.rawClient.createArticle(request).thenApply(response -> response.body());
    }

    /**
     * You can create a new article by making a POST request to <code>https://api.intercom.io/articles</code>.
     */
    public CompletableFuture<Article> createArticle(Object request, RequestOptions requestOptions) {
        return this.rawClient.createArticle(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single article by making a GET request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<Article> retrieveArticle(RetrieveArticleRequest request) {
        return this.rawClient.retrieveArticle(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single article by making a GET request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<Article> retrieveArticle(RetrieveArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveArticle(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can delete a single article by making a DELETE request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<DeletedArticleObject> deleteArticle(DeleteArticleRequest request) {
        return this.rawClient.deleteArticle(request).thenApply(response -> response.body());
    }

    /**
     * You can delete a single article by making a DELETE request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<DeletedArticleObject> deleteArticle(
            DeleteArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteArticle(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can search for articles by making a GET request to <code>https://api.intercom.io/articles/search</code>.
     */
    public CompletableFuture<ArticleSearchResponse> searchArticles() {
        return this.rawClient.searchArticles().thenApply(response -> response.body());
    }

    /**
     * You can search for articles by making a GET request to <code>https://api.intercom.io/articles/search</code>.
     */
    public CompletableFuture<ArticleSearchResponse> searchArticles(SearchArticlesRequest request) {
        return this.rawClient.searchArticles(request).thenApply(response -> response.body());
    }

    /**
     * You can search for articles by making a GET request to <code>https://api.intercom.io/articles/search</code>.
     */
    public CompletableFuture<ArticleSearchResponse> searchArticles(
            SearchArticlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchArticles(request, requestOptions).thenApply(response -> response.body());
    }
}
