/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.articles.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.ArticleTranslatedContent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ArticleListItem.Builder.class)
public final class ArticleListItem implements IArticleListItem {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<String> workspaceId;

    private final Optional<String> title;

    private final Optional<String> description;

    private final Optional<String> body;

    private final Optional<Integer> authorId;

    private final Optional<State> state;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<String> url;

    private final Optional<Integer> parentId;

    private final Optional<List<Integer>> parentIds;

    private final Optional<String> parentType;

    private final Optional<String> defaultLocale;

    private final Optional<ArticleTranslatedContent> translatedContent;

    private final Map<String, Object> additionalProperties;

    private ArticleListItem(
            Optional<String> type,
            Optional<String> id,
            Optional<String> workspaceId,
            Optional<String> title,
            Optional<String> description,
            Optional<String> body,
            Optional<Integer> authorId,
            Optional<State> state,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<String> url,
            Optional<Integer> parentId,
            Optional<List<Integer>> parentIds,
            Optional<String> parentType,
            Optional<String> defaultLocale,
            Optional<ArticleTranslatedContent> translatedContent,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.workspaceId = workspaceId;
        this.title = title;
        this.description = description;
        this.body = body;
        this.authorId = authorId;
        this.state = state;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.url = url;
        this.parentId = parentId;
        this.parentIds = parentIds;
        this.parentType = parentType;
        this.defaultLocale = defaultLocale;
        this.translatedContent = translatedContent;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object - <code>article</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The unique identifier for the article which is given by Intercom.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The id of the workspace which the article belongs to.
     */
    @JsonProperty("workspace_id")
    public Optional<String> getWorkspaceId() {
        return workspaceId;
    }

    /**
     * @return The title of the article. For multilingual articles, this will be the title of the default language's content.
     */
    @JsonProperty("title")
    public Optional<String> getTitle() {
        return title;
    }

    /**
     * @return The description of the article. For multilingual articles, this will be the description of the default language's content.
     */
    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    /**
     * @return The body of the article in HTML. For multilingual articles, this will be the body of the default language's content.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    /**
     * @return The id of the author of the article. For multilingual articles, this will be the id of the author of the default language's content. Must be a teammate on the help center's workspace.
     */
    @JsonProperty("author_id")
    public Optional<Integer> getAuthorId() {
        return authorId;
    }

    /**
     * @return Whether the article is <code>published</code> or is a <code>draft</code>. For multilingual articles, this will be the state of the default language's content.
     */
    @JsonProperty("state")
    public Optional<State> getState() {
        return state;
    }

    /**
     * @return The time when the article was created. For multilingual articles, this will be the timestamp of creation of the default language's content in seconds.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time when the article was last updated. For multilingual articles, this will be the timestamp of last update of the default language's content in seconds.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The URL of the article. For multilingual articles, this will be the URL of the default language's content.
     */
    @JsonProperty("url")
    public Optional<String> getUrl() {
        return url;
    }

    /**
     * @return The id of the article's parent collection or section. An article without this field stands alone.
     */
    @JsonProperty("parent_id")
    public Optional<Integer> getParentId() {
        return parentId;
    }

    /**
     * @return The ids of the article's parent collections or sections. An article without this field stands alone.
     */
    @JsonProperty("parent_ids")
    public Optional<List<Integer>> getParentIds() {
        return parentIds;
    }

    /**
     * @return The type of parent, which can either be a <code>collection</code> or <code>section</code>.
     */
    @JsonProperty("parent_type")
    public Optional<String> getParentType() {
        return parentType;
    }

    /**
     * @return The default locale of the help center. This field is only returned for multilingual help centers.
     */
    @JsonProperty("default_locale")
    public Optional<String> getDefaultLocale() {
        return defaultLocale;
    }

    @JsonProperty("translated_content")
    public Optional<ArticleTranslatedContent> getTranslatedContent() {
        return translatedContent;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ArticleListItem && equalTo((ArticleListItem) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ArticleListItem other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && workspaceId.equals(other.workspaceId)
                && title.equals(other.title)
                && description.equals(other.description)
                && body.equals(other.body)
                && authorId.equals(other.authorId)
                && state.equals(other.state)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && url.equals(other.url)
                && parentId.equals(other.parentId)
                && parentIds.equals(other.parentIds)
                && parentType.equals(other.parentType)
                && defaultLocale.equals(other.defaultLocale)
                && translatedContent.equals(other.translatedContent);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.workspaceId,
                this.title,
                this.description,
                this.body,
                this.authorId,
                this.state,
                this.createdAt,
                this.updatedAt,
                this.url,
                this.parentId,
                this.parentIds,
                this.parentType,
                this.defaultLocale,
                this.translatedContent);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> workspaceId = Optional.empty();

        private Optional<String> title = Optional.empty();

        private Optional<String> description = Optional.empty();

        private Optional<String> body = Optional.empty();

        private Optional<Integer> authorId = Optional.empty();

        private Optional<State> state = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<String> url = Optional.empty();

        private Optional<Integer> parentId = Optional.empty();

        private Optional<List<Integer>> parentIds = Optional.empty();

        private Optional<String> parentType = Optional.empty();

        private Optional<String> defaultLocale = Optional.empty();

        private Optional<ArticleTranslatedContent> translatedContent = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ArticleListItem other) {
            type(other.getType());
            id(other.getId());
            workspaceId(other.getWorkspaceId());
            title(other.getTitle());
            description(other.getDescription());
            body(other.getBody());
            authorId(other.getAuthorId());
            state(other.getState());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            url(other.getUrl());
            parentId(other.getParentId());
            parentIds(other.getParentIds());
            parentType(other.getParentType());
            defaultLocale(other.getDefaultLocale());
            translatedContent(other.getTranslatedContent());
            return this;
        }

        /**
         * <p>The type of object - <code>article</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The unique identifier for the article which is given by Intercom.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The id of the workspace which the article belongs to.</p>
         */
        @JsonSetter(value = "workspace_id", nulls = Nulls.SKIP)
        public Builder workspaceId(Optional<String> workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = Optional.ofNullable(workspaceId);
            return this;
        }

        /**
         * <p>The title of the article. For multilingual articles, this will be the title of the default language's content.</p>
         */
        @JsonSetter(value = "title", nulls = Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        /**
         * <p>The description of the article. For multilingual articles, this will be the description of the default language's content.</p>
         */
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * <p>The body of the article in HTML. For multilingual articles, this will be the body of the default language's content.</p>
         */
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>The id of the author of the article. For multilingual articles, this will be the id of the author of the default language's content. Must be a teammate on the help center's workspace.</p>
         */
        @JsonSetter(value = "author_id", nulls = Nulls.SKIP)
        public Builder authorId(Optional<Integer> authorId) {
            this.authorId = authorId;
            return this;
        }

        public Builder authorId(Integer authorId) {
            this.authorId = Optional.ofNullable(authorId);
            return this;
        }

        /**
         * <p>Whether the article is <code>published</code> or is a <code>draft</code>. For multilingual articles, this will be the state of the default language's content.</p>
         */
        @JsonSetter(value = "state", nulls = Nulls.SKIP)
        public Builder state(Optional<State> state) {
            this.state = state;
            return this;
        }

        public Builder state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        /**
         * <p>The time when the article was created. For multilingual articles, this will be the timestamp of creation of the default language's content in seconds.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The time when the article was last updated. For multilingual articles, this will be the timestamp of last update of the default language's content in seconds.</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The URL of the article. For multilingual articles, this will be the URL of the default language's content.</p>
         */
        @JsonSetter(value = "url", nulls = Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        /**
         * <p>The id of the article's parent collection or section. An article without this field stands alone.</p>
         */
        @JsonSetter(value = "parent_id", nulls = Nulls.SKIP)
        public Builder parentId(Optional<Integer> parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder parentId(Integer parentId) {
            this.parentId = Optional.ofNullable(parentId);
            return this;
        }

        /**
         * <p>The ids of the article's parent collections or sections. An article without this field stands alone.</p>
         */
        @JsonSetter(value = "parent_ids", nulls = Nulls.SKIP)
        public Builder parentIds(Optional<List<Integer>> parentIds) {
            this.parentIds = parentIds;
            return this;
        }

        public Builder parentIds(List<Integer> parentIds) {
            this.parentIds = Optional.ofNullable(parentIds);
            return this;
        }

        /**
         * <p>The type of parent, which can either be a <code>collection</code> or <code>section</code>.</p>
         */
        @JsonSetter(value = "parent_type", nulls = Nulls.SKIP)
        public Builder parentType(Optional<String> parentType) {
            this.parentType = parentType;
            return this;
        }

        public Builder parentType(String parentType) {
            this.parentType = Optional.ofNullable(parentType);
            return this;
        }

        /**
         * <p>The default locale of the help center. This field is only returned for multilingual help centers.</p>
         */
        @JsonSetter(value = "default_locale", nulls = Nulls.SKIP)
        public Builder defaultLocale(Optional<String> defaultLocale) {
            this.defaultLocale = defaultLocale;
            return this;
        }

        public Builder defaultLocale(String defaultLocale) {
            this.defaultLocale = Optional.ofNullable(defaultLocale);
            return this;
        }

        @JsonSetter(value = "translated_content", nulls = Nulls.SKIP)
        public Builder translatedContent(Optional<ArticleTranslatedContent> translatedContent) {
            this.translatedContent = translatedContent;
            return this;
        }

        public Builder translatedContent(ArticleTranslatedContent translatedContent) {
            this.translatedContent = Optional.ofNullable(translatedContent);
            return this;
        }

        public ArticleListItem build() {
            return new ArticleListItem(
                    type,
                    id,
                    workspaceId,
                    title,
                    description,
                    body,
                    authorId,
                    state,
                    createdAt,
                    updatedAt,
                    url,
                    parentId,
                    parentIds,
                    parentType,
                    defaultLocale,
                    translatedContent,
                    additionalProperties);
        }
    }

    public static final class State {
        public static final State PUBLISHED = new State(Value.PUBLISHED, "published");

        public static final State DRAFT = new State(Value.DRAFT, "draft");

        private final Value value;

        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof State && this.string.equals(((State) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case PUBLISHED:
                    return visitor.visitPublished();
                case DRAFT:
                    return visitor.visitDraft();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "published":
                    return PUBLISHED;
                case "draft":
                    return DRAFT;
                default:
                    return new State(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            PUBLISHED,

            DRAFT,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitPublished();

            T visitDraft();

            T visitUnknown(String unknownType);
        }
    }
}
