/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.tickettypeattributes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.tickettypeattributes.requests.CreateTicketTypeAttributeRequest;
import com.intercom.api.resources.unstable.tickettypeattributes.requests.UpdateTicketTypeAttributeRequest;
import com.intercom.api.resources.unstable.types.TicketTypeAttribute;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncTicketTypeAttributesClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTicketTypeAttributesClient rawClient;

    public AsyncTicketTypeAttributesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTicketTypeAttributesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTicketTypeAttributesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can create a new attribute for a ticket type.
     */
    public CompletableFuture<Optional<TicketTypeAttribute>> createTicketTypeAttribute(
            CreateTicketTypeAttributeRequest request) {
        return this.rawClient.createTicketTypeAttribute(request).thenApply(response -> response.body());
    }

    /**
     * You can create a new attribute for a ticket type.
     */
    public CompletableFuture<Optional<TicketTypeAttribute>> createTicketTypeAttribute(
            CreateTicketTypeAttributeRequest request, RequestOptions requestOptions) {
        return this.rawClient.createTicketTypeAttribute(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can update an existing attribute for a ticket type.
     */
    public CompletableFuture<Optional<TicketTypeAttribute>> updateTicketTypeAttribute(
            UpdateTicketTypeAttributeRequest request) {
        return this.rawClient.updateTicketTypeAttribute(request).thenApply(response -> response.body());
    }

    /**
     * You can update an existing attribute for a ticket type.
     */
    public CompletableFuture<Optional<TicketTypeAttribute>> updateTicketTypeAttribute(
            UpdateTicketTypeAttributeRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateTicketTypeAttribute(request, requestOptions).thenApply(response -> response.body());
    }
}
