/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.companies.types.Company;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CompanyScroll.Builder.class)
public final class CompanyScroll {
    private final Optional<String> type;

    private final Optional<List<Company>> data;

    private final Optional<CursorPages> pages;

    private final Optional<Integer> totalCount;

    private final Optional<String> scrollParam;

    private final Map<String, Object> additionalProperties;

    private CompanyScroll(
            Optional<String> type,
            Optional<List<Company>> data,
            Optional<CursorPages> pages,
            Optional<Integer> totalCount,
            Optional<String> scrollParam,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.data = data;
        this.pages = pages;
        this.totalCount = totalCount;
        this.scrollParam = scrollParam;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object - <code>list</code>
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    @JsonProperty("data")
    public Optional<List<Company>> getData() {
        return data;
    }

    @JsonProperty("pages")
    public Optional<CursorPages> getPages() {
        return pages;
    }

    /**
     * @return The total number of companies
     */
    @JsonProperty("total_count")
    public Optional<Integer> getTotalCount() {
        return totalCount;
    }

    /**
     * @return The scroll parameter to use in the next request to fetch the next page of results.
     */
    @JsonProperty("scroll_param")
    public Optional<String> getScrollParam() {
        return scrollParam;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CompanyScroll && equalTo((CompanyScroll) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyScroll other) {
        return type.equals(other.type)
                && data.equals(other.data)
                && pages.equals(other.pages)
                && totalCount.equals(other.totalCount)
                && scrollParam.equals(other.scrollParam);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.data, this.pages, this.totalCount, this.scrollParam);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<Company>> data = Optional.empty();

        private Optional<CursorPages> pages = Optional.empty();

        private Optional<Integer> totalCount = Optional.empty();

        private Optional<String> scrollParam = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CompanyScroll other) {
            type(other.getType());
            data(other.getData());
            pages(other.getPages());
            totalCount(other.getTotalCount());
            scrollParam(other.getScrollParam());
            return this;
        }

        /**
         * <p>The type of object - <code>list</code></p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public Builder data(Optional<List<Company>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<Company> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public Builder pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        /**
         * <p>The total number of companies</p>
         */
        @JsonSetter(value = "total_count", nulls = Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        /**
         * <p>The scroll parameter to use in the next request to fetch the next page of results.</p>
         */
        @JsonSetter(value = "scroll_param", nulls = Nulls.SKIP)
        public Builder scrollParam(Optional<String> scrollParam) {
            this.scrollParam = scrollParam;
            return this;
        }

        public Builder scrollParam(String scrollParam) {
            this.scrollParam = Optional.ofNullable(scrollParam);
            return this;
        }

        public CompanyScroll build() {
            return new CompanyScroll(type, data, pages, totalCount, scrollParam, additionalProperties);
        }
    }
}
