/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = LinkedObject.Builder.class)
public final class LinkedObject {
    private final Optional<Type> type;

    private final Optional<String> id;

    private final Optional<Category> category;

    private final Map<String, Object> additionalProperties;

    private LinkedObject(
            Optional<Type> type,
            Optional<String> id,
            Optional<Category> category,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.category = category;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return ticket or conversation
     */
    @JsonProperty("type")
    public Optional<Type> getType() {
        return type;
    }

    /**
     * @return The ID of the linked object
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return Category of the Linked Ticket Object.
     */
    @JsonProperty("category")
    public Optional<Category> getCategory() {
        return category;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LinkedObject && equalTo((LinkedObject) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LinkedObject other) {
        return type.equals(other.type) && id.equals(other.id) && category.equals(other.category);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.id, this.category);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Type> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<Category> category = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(LinkedObject other) {
            type(other.getType());
            id(other.getId());
            category(other.getCategory());
            return this;
        }

        /**
         * <p>ticket or conversation</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<Type> type) {
            this.type = type;
            return this;
        }

        public Builder type(Type type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The ID of the linked object</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>Category of the Linked Ticket Object.</p>
         */
        @JsonSetter(value = "category", nulls = Nulls.SKIP)
        public Builder category(Optional<Category> category) {
            this.category = category;
            return this;
        }

        public Builder category(Category category) {
            this.category = Optional.ofNullable(category);
            return this;
        }

        public LinkedObject build() {
            return new LinkedObject(type, id, category, additionalProperties);
        }
    }

    public static final class Category {
        public static final Category BACK_OFFICE = new Category(Value.BACK_OFFICE, "Back-office");

        public static final Category CUSTOMER = new Category(Value.CUSTOMER, "Customer");

        public static final Category TRACKER = new Category(Value.TRACKER, "Tracker");

        private final Value value;

        private final String string;

        Category(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Category && this.string.equals(((Category) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case BACK_OFFICE:
                    return visitor.visitBackOffice();
                case CUSTOMER:
                    return visitor.visitCustomer();
                case TRACKER:
                    return visitor.visitTracker();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Category valueOf(String value) {
            switch (value) {
                case "Back-office":
                    return BACK_OFFICE;
                case "Customer":
                    return CUSTOMER;
                case "Tracker":
                    return TRACKER;
                default:
                    return new Category(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            CUSTOMER,

            BACK_OFFICE,

            TRACKER,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitCustomer();

            T visitBackOffice();

            T visitTracker();

            T visitUnknown(String unknownType);
        }
    }

    public static final class Type {
        public static final Type TICKET = new Type(Value.TICKET, "ticket");

        public static final Type CONVERSATION = new Type(Value.CONVERSATION, "conversation");

        private final Value value;

        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case TICKET:
                    return visitor.visitTicket();
                case CONVERSATION:
                    return visitor.visitConversation();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "ticket":
                    return TICKET;
                case "conversation":
                    return CONVERSATION;
                default:
                    return new Type(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            TICKET,

            CONVERSATION,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitTicket();

            T visitConversation();

            T visitUnknown(String unknownType);
        }
    }
}
