/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketTypeAttributeList.Builder.class)
public final class TicketTypeAttributeList {
    private final Optional<String> type;

    private final Optional<List<Optional<TicketTypeAttribute>>> ticketTypeAttributes;

    private final Map<String, Object> additionalProperties;

    private TicketTypeAttributeList(
            Optional<String> type,
            Optional<List<Optional<TicketTypeAttribute>>> ticketTypeAttributes,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.ticketTypeAttributes = ticketTypeAttributes;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>ticket_type_attributes.list</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return A list of ticket type attributes associated with a given ticket type.
     */
    @JsonProperty("ticket_type_attributes")
    public Optional<List<Optional<TicketTypeAttribute>>> getTicketTypeAttributes() {
        return ticketTypeAttributes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketTypeAttributeList && equalTo((TicketTypeAttributeList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketTypeAttributeList other) {
        return type.equals(other.type) && ticketTypeAttributes.equals(other.ticketTypeAttributes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.ticketTypeAttributes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<Optional<TicketTypeAttribute>>> ticketTypeAttributes = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(TicketTypeAttributeList other) {
            type(other.getType());
            ticketTypeAttributes(other.getTicketTypeAttributes());
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>ticket_type_attributes.list</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>A list of ticket type attributes associated with a given ticket type.</p>
         */
        @JsonSetter(value = "ticket_type_attributes", nulls = Nulls.SKIP)
        public Builder ticketTypeAttributes(Optional<List<Optional<TicketTypeAttribute>>> ticketTypeAttributes) {
            this.ticketTypeAttributes = ticketTypeAttributes;
            return this;
        }

        public Builder ticketTypeAttributes(List<Optional<TicketTypeAttribute>> ticketTypeAttributes) {
            this.ticketTypeAttributes = Optional.ofNullable(ticketTypeAttributes);
            return this;
        }

        public TicketTypeAttributeList build() {
            return new TicketTypeAttributeList(type, ticketTypeAttributes, additionalProperties);
        }
    }
}
