/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.admins;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.admins.RawAdminsClient;
import com.intercom.api.resources.admins.requests.ConfigureAwayAdminRequest;
import com.intercom.api.resources.admins.requests.FindAdminRequest;
import com.intercom.api.resources.admins.requests.ListAllActivityLogsRequest;
import com.intercom.api.resources.admins.types.Admin;
import com.intercom.api.types.ActivityLogList;
import com.intercom.api.types.AdminList;
import com.intercom.api.types.AdminWithApp;
import java.util.Optional;

public class AdminsClient {
    protected final ClientOptions clientOptions;
    private final RawAdminsClient rawClient;

    public AdminsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawAdminsClient(clientOptions);
    }

    public RawAdminsClient withRawResponse() {
        return this.rawClient;
    }

    public Optional<AdminWithApp> identify() {
        return this.rawClient.identify().body();
    }

    public Optional<AdminWithApp> identify(RequestOptions requestOptions) {
        return this.rawClient.identify(requestOptions).body();
    }

    public Optional<Admin> away(ConfigureAwayAdminRequest request) {
        return this.rawClient.away(request).body();
    }

    public Optional<Admin> away(ConfigureAwayAdminRequest request, RequestOptions requestOptions) {
        return this.rawClient.away(request, requestOptions).body();
    }

    public ActivityLogList listAllActivityLogs(ListAllActivityLogsRequest request) {
        return this.rawClient.listAllActivityLogs(request).body();
    }

    public ActivityLogList listAllActivityLogs(ListAllActivityLogsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAllActivityLogs(request, requestOptions).body();
    }

    public AdminList list() {
        return this.rawClient.list().body();
    }

    public AdminList list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).body();
    }

    public Optional<Admin> find(FindAdminRequest request) {
        return this.rawClient.find(request).body();
    }

    public Optional<Admin> find(FindAdminRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }
}

