/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.calls.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListCallsRequest {
    private final Optional<Integer> page;
    private final Optional<Integer> perPage;
    private final Map<String, Object> additionalProperties;

    private ListCallsRequest(Optional<Integer> page, Optional<Integer> perPage, Map<String, Object> additionalProperties) {
        this.page = page;
        this.perPage = perPage;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="page")
    public Optional<Integer> getPage() {
        return this.page;
    }

    @JsonProperty(value="per_page")
    public Optional<Integer> getPerPage() {
        return this.perPage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListCallsRequest && this.equalTo((ListCallsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCallsRequest other) {
        return this.page.equals(other.page) && this.perPage.equals(other.perPage);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.perPage);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> page = Optional.empty();
        private Optional<Integer> perPage = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListCallsRequest other) {
            this.page(other.getPage());
            this.perPage(other.getPerPage());
            return this;
        }

        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @JsonSetter(value="per_page", nulls=Nulls.SKIP)
        public Builder perPage(Optional<Integer> perPage) {
            this.perPage = perPage;
            return this;
        }

        public Builder perPage(Integer perPage) {
            this.perPage = Optional.ofNullable(perPage);
            return this;
        }

        public ListCallsRequest build() {
            return new ListCallsRequest(this.page, this.perPage, this.additionalProperties);
        }
    }
}

