/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.companies;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.companies.AsyncRawCompaniesClient;
import com.intercom.api.resources.unstable.companies.requests.AttachContactToACompanyRequest;
import com.intercom.api.resources.unstable.companies.requests.DeleteCompanyRequest;
import com.intercom.api.resources.unstable.companies.requests.DetachContactFromACompanyRequest;
import com.intercom.api.resources.unstable.companies.requests.ListAllCompaniesRequest;
import com.intercom.api.resources.unstable.companies.requests.ListAttachedContactsRequest;
import com.intercom.api.resources.unstable.companies.requests.ListAttachedSegmentsForCompaniesRequest;
import com.intercom.api.resources.unstable.companies.requests.RetrieveACompanyByIdRequest;
import com.intercom.api.resources.unstable.companies.requests.RetrieveCompanyRequest;
import com.intercom.api.resources.unstable.companies.requests.ScrollOverAllCompaniesRequest;
import com.intercom.api.resources.unstable.companies.requests.UpdateCompanyRequest;
import com.intercom.api.resources.unstable.companies.types.Company;
import com.intercom.api.resources.unstable.types.CompanyAttachedContacts;
import com.intercom.api.resources.unstable.types.CompanyAttachedSegments;
import com.intercom.api.resources.unstable.types.CompanyList;
import com.intercom.api.resources.unstable.types.CompanyScroll;
import com.intercom.api.resources.unstable.types.DeletedCompanyObject;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncCompaniesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCompaniesClient rawClient;

    public AsyncCompaniesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCompaniesClient(clientOptions);
    }

    public AsyncRawCompaniesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CompanyList> retrieveCompany() {
        return this.rawClient.retrieveCompany().thenApply(response -> (CompanyList)response.body());
    }

    public CompletableFuture<CompanyList> retrieveCompany(RetrieveCompanyRequest request) {
        return this.rawClient.retrieveCompany(request).thenApply(response -> (CompanyList)response.body());
    }

    public CompletableFuture<CompanyList> retrieveCompany(RetrieveCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveCompany(request, requestOptions).thenApply(response -> (CompanyList)response.body());
    }

    public CompletableFuture<Company> createOrUpdateCompany(Object request) {
        return this.rawClient.createOrUpdateCompany(request).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> createOrUpdateCompany(Object request, RequestOptions requestOptions) {
        return this.rawClient.createOrUpdateCompany(request, requestOptions).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> retrieveACompanyById(RetrieveACompanyByIdRequest request) {
        return this.rawClient.retrieveACompanyById(request).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> retrieveACompanyById(RetrieveACompanyByIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveACompanyById(request, requestOptions).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> updateCompany(UpdateCompanyRequest request) {
        return this.rawClient.updateCompany(request).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> updateCompany(UpdateCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateCompany(request, requestOptions).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<DeletedCompanyObject> deleteCompany(DeleteCompanyRequest request) {
        return this.rawClient.deleteCompany(request).thenApply(response -> (DeletedCompanyObject)response.body());
    }

    public CompletableFuture<DeletedCompanyObject> deleteCompany(DeleteCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteCompany(request, requestOptions).thenApply(response -> (DeletedCompanyObject)response.body());
    }

    public CompletableFuture<CompanyAttachedContacts> listAttachedContacts(ListAttachedContactsRequest request) {
        return this.rawClient.listAttachedContacts(request).thenApply(response -> (CompanyAttachedContacts)response.body());
    }

    public CompletableFuture<CompanyAttachedContacts> listAttachedContacts(ListAttachedContactsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedContacts(request, requestOptions).thenApply(response -> (CompanyAttachedContacts)response.body());
    }

    public CompletableFuture<CompanyAttachedSegments> listAttachedSegmentsForCompanies(ListAttachedSegmentsForCompaniesRequest request) {
        return this.rawClient.listAttachedSegmentsForCompanies(request).thenApply(response -> (CompanyAttachedSegments)response.body());
    }

    public CompletableFuture<CompanyAttachedSegments> listAttachedSegmentsForCompanies(ListAttachedSegmentsForCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedSegmentsForCompanies(request, requestOptions).thenApply(response -> (CompanyAttachedSegments)response.body());
    }

    public CompletableFuture<CompanyList> listAllCompanies() {
        return this.rawClient.listAllCompanies().thenApply(response -> (CompanyList)response.body());
    }

    public CompletableFuture<CompanyList> listAllCompanies(ListAllCompaniesRequest request) {
        return this.rawClient.listAllCompanies(request).thenApply(response -> (CompanyList)response.body());
    }

    public CompletableFuture<CompanyList> listAllCompanies(ListAllCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAllCompanies(request, requestOptions).thenApply(response -> (CompanyList)response.body());
    }

    public CompletableFuture<Optional<CompanyScroll>> scrollOverAllCompanies() {
        return this.rawClient.scrollOverAllCompanies().thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<CompanyScroll>> scrollOverAllCompanies(ScrollOverAllCompaniesRequest request) {
        return this.rawClient.scrollOverAllCompanies(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<CompanyScroll>> scrollOverAllCompanies(ScrollOverAllCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.scrollOverAllCompanies(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Company> attachContactToACompany(AttachContactToACompanyRequest request) {
        return this.rawClient.attachContactToACompany(request).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> attachContactToACompany(AttachContactToACompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachContactToACompany(request, requestOptions).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> detachContactFromACompany(DetachContactFromACompanyRequest request) {
        return this.rawClient.detachContactFromACompany(request).thenApply(response -> (Company)response.body());
    }

    public CompletableFuture<Company> detachContactFromACompany(DetachContactFromACompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachContactFromACompany(request, requestOptions).thenApply(response -> (Company)response.body());
    }
}

