/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.news;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.news.RawNewsClient;
import com.intercom.api.resources.unstable.news.requests.DeleteNewsItemRequest;
import com.intercom.api.resources.unstable.news.requests.ListLiveNewsfeedItemsRequest;
import com.intercom.api.resources.unstable.news.requests.RetrieveNewsItemRequest;
import com.intercom.api.resources.unstable.news.requests.RetrieveNewsfeedRequest;
import com.intercom.api.resources.unstable.news.requests.UpdateNewsItemRequest;
import com.intercom.api.resources.unstable.news.types.NewsItem;
import com.intercom.api.resources.unstable.news.types.Newsfeed;
import com.intercom.api.resources.unstable.types.DeletedObject;
import com.intercom.api.resources.unstable.types.NewsItemRequest;
import com.intercom.api.resources.unstable.types.PaginatedResponse;

public class NewsClient {
    protected final ClientOptions clientOptions;
    private final RawNewsClient rawClient;

    public NewsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawNewsClient(clientOptions);
    }

    public RawNewsClient withRawResponse() {
        return this.rawClient;
    }

    public PaginatedResponse listNewsItems() {
        return this.rawClient.listNewsItems().body();
    }

    public PaginatedResponse listNewsItems(RequestOptions requestOptions) {
        return this.rawClient.listNewsItems(requestOptions).body();
    }

    public NewsItem createNewsItem(NewsItemRequest request) {
        return this.rawClient.createNewsItem(request).body();
    }

    public NewsItem createNewsItem(NewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.createNewsItem(request, requestOptions).body();
    }

    public NewsItem retrieveNewsItem(RetrieveNewsItemRequest request) {
        return this.rawClient.retrieveNewsItem(request).body();
    }

    public NewsItem retrieveNewsItem(RetrieveNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveNewsItem(request, requestOptions).body();
    }

    public NewsItem updateNewsItem(UpdateNewsItemRequest request) {
        return this.rawClient.updateNewsItem(request).body();
    }

    public NewsItem updateNewsItem(UpdateNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateNewsItem(request, requestOptions).body();
    }

    public DeletedObject deleteNewsItem(DeleteNewsItemRequest request) {
        return this.rawClient.deleteNewsItem(request).body();
    }

    public DeletedObject deleteNewsItem(DeleteNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteNewsItem(request, requestOptions).body();
    }

    public PaginatedResponse listLiveNewsfeedItems(ListLiveNewsfeedItemsRequest request) {
        return this.rawClient.listLiveNewsfeedItems(request).body();
    }

    public PaginatedResponse listLiveNewsfeedItems(ListLiveNewsfeedItemsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listLiveNewsfeedItems(request, requestOptions).body();
    }

    public PaginatedResponse listNewsfeeds() {
        return this.rawClient.listNewsfeeds().body();
    }

    public PaginatedResponse listNewsfeeds(RequestOptions requestOptions) {
        return this.rawClient.listNewsfeeds(requestOptions).body();
    }

    public Newsfeed retrieveNewsfeed(RetrieveNewsfeedRequest request) {
        return this.rawClient.retrieveNewsfeed(request).body();
    }

    public Newsfeed retrieveNewsfeed(RetrieveNewsfeedRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveNewsfeed(request, requestOptions).body();
    }
}

