/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.tags.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AttachTagToTicketRequest {
    private final String ticketId;
    private final String id;
    private final String adminId;
    private final Map<String, Object> additionalProperties;

    private AttachTagToTicketRequest(String ticketId, String id, String adminId, Map<String, Object> additionalProperties) {
        this.ticketId = ticketId;
        this.id = id;
        this.adminId = adminId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ticket_id")
    public String getTicketId() {
        return this.ticketId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="admin_id")
    public String getAdminId() {
        return this.adminId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AttachTagToTicketRequest && this.equalTo((AttachTagToTicketRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AttachTagToTicketRequest other) {
        return this.ticketId.equals(other.ticketId) && this.id.equals(other.id) && this.adminId.equals(other.adminId);
    }

    public int hashCode() {
        return Objects.hash(this.ticketId, this.id, this.adminId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TicketIdStage,
    IdStage,
    AdminIdStage,
    _FinalStage {
        private String ticketId;
        private String id;
        private String adminId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AttachTagToTicketRequest other) {
            this.ticketId(other.getTicketId());
            this.id(other.getId());
            this.adminId(other.getAdminId());
            return this;
        }

        @Override
        @JsonSetter(value="ticket_id")
        public IdStage ticketId(@NotNull String ticketId) {
            this.ticketId = Objects.requireNonNull(ticketId, "ticketId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public AdminIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="admin_id")
        public _FinalStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        @Override
        public AttachTagToTicketRequest build() {
            return new AttachTagToTicketRequest(this.ticketId, this.id, this.adminId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AttachTagToTicketRequest build();
    }

    public static interface AdminIdStage {
        public _FinalStage adminId(@NotNull String var1);
    }

    public static interface IdStage {
        public AdminIdStage id(@NotNull String var1);
    }

    public static interface TicketIdStage {
        public IdStage ticketId(@NotNull String var1);

        public Builder from(AttachTagToTicketRequest var1);
    }
}

