/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Translation {
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<String> locale;
    private final Map<String, Object> additionalProperties;

    private Translation(Optional<String> name, Optional<String> description, Optional<String> locale, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.locale = locale;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="locale")
    public Optional<String> getLocale() {
        return this.locale;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Translation && this.equalTo((Translation)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Translation other) {
        return this.name.equals(other.name) && this.description.equals(other.description) && this.locale.equals(other.locale);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.locale);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> locale = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Translation other) {
            this.name(other.getName());
            this.description(other.getDescription());
            this.locale(other.getLocale());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="locale", nulls=Nulls.SKIP)
        public Builder locale(Optional<String> locale) {
            this.locale = locale;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = Optional.ofNullable(locale);
            return this;
        }

        public Translation build() {
            return new Translation(this.name, this.description, this.locale, this.additionalProperties);
        }
    }
}

