/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.annotations.Receiver;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.holder.HasReceiverRegistration;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class ReceiverHandler
extends BaseAnnotationHandler<HasReceiverRegistration> {
    public ReceiverHandler(ProcessingEnvironment processingEnvironment) {
        super(Receiver.class, processingEnvironment);
    }

    @Override
    protected void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEActivityOrEFragmentOrEServiceOrEIntentService(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, valid);
        this.validatorHelper.param.zeroOrOneIntentParameter((ExecutableElement)element, valid);
        this.validatorHelper.hasNotMultipleAnnotatedMethodWithSameName(element.getEnclosingElement(), valid, Receiver.class);
        this.validatorHelper.hasRightRegisterAtValueDependingOnEnclosingElement(element, valid);
        this.validatorHelper.hasSupportV4JarIfLocal(element, valid);
    }

    @Override
    public void process(Element element, HasReceiverRegistration holder) throws Exception {
        String methodName = element.getSimpleName().toString();
        boolean hasIntentParam = !((ExecutableElement)element).getParameters().isEmpty();
        String receiverName = methodName + "Receiver" + "_";
        Receiver annotation = element.getAnnotation(Receiver.class);
        String[] actions = annotation.actions();
        Receiver.RegisterAt registerAt = annotation.registerAt();
        boolean local = annotation.local();
        JFieldVar intentFilterField = holder.getIntentFilterField(actions);
        JFieldVar receiverField = this.createReceiverField(holder, receiverName, methodName, hasIntentParam);
        this.registerAndUnregisterReceiver(holder, registerAt, intentFilterField, receiverField, local);
    }

    private JFieldVar createReceiverField(HasReceiverRegistration holder, String receiverName, String methodName, boolean hasIntentParam) {
        JDefinedClass anonymousReceiverClass = this.codeModel().anonymousClass(this.classes().BROADCAST_RECEIVER);
        JMethod onReceiveMethod = anonymousReceiverClass.method(1, this.codeModel().VOID, "onReceive");
        onReceiveMethod.param(this.classes().CONTEXT, "context");
        JVar intentVar = onReceiveMethod.param(this.classes().INTENT, "intent");
        JInvocation methodCall = onReceiveMethod.body().invoke(methodName);
        if (hasIntentParam) {
            methodCall.arg(intentVar);
        }
        JInvocation receiverInit = JExpr._new(anonymousReceiverClass);
        return holder.getGeneratedClass().field(12, this.classes().BROADCAST_RECEIVER, receiverName, (JExpression)receiverInit);
    }

    private void registerAndUnregisterReceiver(HasReceiverRegistration holder, Receiver.RegisterAt registerAt, JFieldVar intentFilterField, JFieldVar receiverField, boolean local) {
        JBlock registerBlock = null;
        JBlock unregisterBlock = null;
        switch (registerAt) {
            case OnCreateOnDestroy: {
                registerBlock = holder.getOnCreateAfterSuperBlock();
                unregisterBlock = holder.getOnDestroyBeforeSuperBlock();
                break;
            }
            case OnStartOnStop: {
                registerBlock = holder.getOnStartAfterSuperBlock();
                unregisterBlock = holder.getOnStopBeforeSuperBlock();
                break;
            }
            case OnResumeOnPause: {
                registerBlock = holder.getOnResumeAfterSuperBlock();
                unregisterBlock = holder.getOnPauseBeforeSuperBlock();
                break;
            }
            case OnAttachOnDetach: {
                registerBlock = holder.getOnAttachAfterSuperBlock();
                unregisterBlock = holder.getOnDetachBeforeSuperBlock();
            }
        }
        JExpression broadcastManager = local ? this.classes().LOCAL_BROADCAST_MANAGER.staticInvoke("getInstance").arg(holder.getContextRef()) : holder.getContextRef();
        registerBlock.invoke(broadcastManager, "registerReceiver").arg(receiverField).arg(intentFilterField);
        unregisterBlock.invoke(broadcastManager, "unregisterReceiver").arg(receiverField);
    }
}

