/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JVar;
import org.androidannotations.api.view.HasViews;
import org.androidannotations.api.view.OnViewChangedNotifier;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.holder.EViewHolder;

public class ViewNotifierHelper {
    private EComponentHolder holder;
    private JFieldVar notifier;

    public ViewNotifierHelper(EComponentHolder holder) {
        this.holder = holder;
    }

    public void invokeViewChanged(JBlock block) {
        block.invoke((JExpression)this.notifier, "notifyViewChanged").arg(JExpr._this());
    }

    public JVar replacePreviousNotifier(JBlock block) {
        JClass notifierClass = this.holder.refClass(OnViewChangedNotifier.class);
        if (this.notifier == null) {
            this.notifier = this.holder.getGeneratedClass().field(12, notifierClass, "onViewChangedNotifier_", (JExpression)JExpr._new(notifierClass));
            this.holder.getGeneratedClass()._implements(HasViews.class);
        }
        return block.decl(notifierClass, "previousNotifier", notifierClass.staticInvoke("replaceNotifier").arg(this.notifier));
    }

    public JVar replacePreviousNotifierWithNull(JBlock block) {
        JClass notifierClass = this.holder.refClass(OnViewChangedNotifier.class);
        return block.decl(notifierClass, "previousNotifier", notifierClass.staticInvoke("replaceNotifier").arg(JExpr._null()));
    }

    public void resetPreviousNotifier(JBlock block, JVar previousNotifier) {
        JClass notifierClass = this.holder.refClass(OnViewChangedNotifier.class);
        block.staticInvoke(notifierClass, "replaceNotifier").arg(previousNotifier);
    }

    public void wrapInitWithNotifier() {
        JBlock initBlock = this.holder.getInit().body();
        JVar previousNotifier = this.replacePreviousNotifier(initBlock);
        ((EViewHolder)this.holder).setInitBody(this.holder.getInit().body().block());
        this.resetPreviousNotifier(initBlock.block(), previousNotifier);
    }
}

