/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.DataSource;
import org.biojava.nbio.core.sequence.TaxonomyID;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.features.AbstractFeature;
import org.biojava.nbio.core.sequence.features.DBReferenceInfo;
import org.biojava.nbio.core.sequence.io.DNASequenceCreator;
import org.biojava.nbio.core.sequence.io.GenbankSequenceParser;
import org.biojava.nbio.core.sequence.io.GenericGenbankHeaderParser;
import org.biojava.nbio.core.sequence.io.ProteinSequenceCreator;
import org.biojava.nbio.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava.nbio.core.sequence.io.template.SequenceHeaderParserInterface;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Compound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenbankReader<S extends AbstractSequence<C>, C extends Compound> {
    private SequenceCreatorInterface<C> sequenceCreator;
    private GenbankSequenceParser<S, C> genbankParser;
    private BufferedReader bufferedReader;
    private boolean closed;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean isClosed() {
        return this.closed;
    }

    public GenbankReader(InputStream is, SequenceHeaderParserInterface<S, C> headerParser, SequenceCreatorInterface<C> sequenceCreator) {
        this.sequenceCreator = sequenceCreator;
        this.bufferedReader = new BufferedReader(new InputStreamReader(is));
        this.genbankParser = new GenbankSequenceParser();
        this.closed = false;
    }

    public GenbankReader(File file, SequenceHeaderParserInterface<S, C> headerParser, SequenceCreatorInterface<C> sequenceCreator) throws FileNotFoundException {
        this.bufferedReader = new BufferedReader(new FileReader(file));
        this.sequenceCreator = sequenceCreator;
        this.genbankParser = new GenbankSequenceParser();
    }

    public LinkedHashMap<String, S> process() throws IOException, CompoundNotFoundException {
        return this.process(-1);
    }

    public LinkedHashMap<String, S> process(int max) throws IOException, CompoundNotFoundException {
        LinkedHashMap<String, AbstractSequence<C>> sequences = new LinkedHashMap<String, AbstractSequence<C>>();
        int i = 0;
        while (max <= 0 || i < max) {
            ++i;
            String seqString = this.genbankParser.getSequence(this.bufferedReader, 0);
            if (seqString == null) break;
            AbstractSequence<C> sequence = this.sequenceCreator.getSequence(seqString, 0L);
            this.genbankParser.getSequenceHeaderParser().parseHeader(this.genbankParser.getHeader(), sequence);
            for (String k : this.genbankParser.getFeatures().keySet()) {
                for (AbstractFeature f : this.genbankParser.getFeatures(k)) {
                    sequence.addFeature(f);
                }
            }
            ArrayList<DBReferenceInfo> dbQualifier = this.genbankParser.getDatabaseReferences().get("db_xref");
            if (dbQualifier != null) {
                DBReferenceInfo q = dbQualifier.get(0);
                sequence.setTaxonomy(new TaxonomyID(q.getDatabase() + ":" + q.getId(), DataSource.GENBANK));
            }
            sequences.put(sequence.getAccession().getID(), sequence);
        }
        if (max < 0) {
            this.close();
        }
        return sequences;
    }

    public void close() {
        try {
            this.bufferedReader.close();
            this.closed = true;
        }
        catch (IOException e) {
            this.logger.error("Couldn't close the reader. {}", (Object)e.getMessage());
            this.closed = false;
        }
    }

    public static void main(String[] args) throws Exception {
        String proteinFile = "src/test/resources/BondFeature.gb";
        FileInputStream is = new FileInputStream(proteinFile);
        GenbankReader proteinReader = new GenbankReader(is, new GenericGenbankHeaderParser(), new ProteinSequenceCreator(AminoAcidCompoundSet.getAminoAcidCompoundSet()));
        LinkedHashMap proteinSequences = proteinReader.process();
        System.out.println(proteinSequences);
        String inputFile = "src/test/resources/NM_000266.gb";
        is = new FileInputStream(inputFile);
        GenbankReader dnaReader = new GenbankReader(is, new GenericGenbankHeaderParser(), new DNASequenceCreator(DNACompoundSet.getDNACompoundSet()));
        LinkedHashMap dnaSequences = dnaReader.process();
        System.out.println(dnaSequences);
        String crazyFile = "src/test/resources/CraftedFeature.gb";
        is = new FileInputStream(crazyFile);
        GenbankReader crazyReader = new GenbankReader(is, new GenericGenbankHeaderParser(), new DNASequenceCreator(DNACompoundSet.getDNACompoundSet()));
        LinkedHashMap crazyAnnotatedSequences = crazyReader.process();
        is.close();
        System.out.println(crazyAnnotatedSequences);
    }
}

