/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.biojava.nbio.structure.align.gui.ChooseDirAction;
import org.biojava.nbio.structure.align.gui.MyAction;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.WebStartMain;
import org.biojava.nbio.structure.gui.util.PDBUploadPanel;
import org.biojava.nbio.structure.io.LocalPDBDirectory;

public class ConfigPDBInstallPanel
extends JPanel {
    private static final long serialVersionUID = -1055193854675583808L;
    JCheckBox fromFtp;
    JComboBox fileType;
    JTextField pdbDir;
    private static ConfigPDBInstallPanel instance = new ConfigPDBInstallPanel();
    static JDialog dialog;

    private ConfigPDBInstallPanel() {
        UserConfiguration config = WebStartMain.getWebStartConfig();
        this.fileType = PDBUploadPanel.getFileFormatSelect();
        Box vBox = Box.createVerticalBox();
        Box hBox = Box.createHorizontalBox();
        this.pdbDir = new JTextField(20);
        String conf = System.getProperty("PDB_DIR");
        if (conf != null) {
            this.pdbDir.setText(conf);
        }
        JLabel l01 = new JLabel("Directory containing PDBs");
        hBox.add(l01);
        hBox.add(this.pdbDir);
        vBox.add(hBox);
        if (config != null) {
            this.pdbDir.setText(config.getPdbFilePath());
        }
        ChooseDirAction action = new ChooseDirAction(this.pdbDir, config);
        JButton chooser = new JButton(action);
        hBox.add(chooser);
        Box hBox3 = Box.createHorizontalBox();
        JLabel label2 = new JLabel("Fetch missing PDBs from ftp site:");
        this.fromFtp = new JCheckBox();
        this.fromFtp.setMnemonic(70);
        this.fromFtp.setSelected(true);
        if (config != null) {
            this.fromFtp.setSelected(config.getFetchBehavior() != LocalPDBDirectory.FetchBehavior.LOCAL_ONLY);
        }
        JLabel ftype = new JLabel("File format:");
        hBox3.add(Box.createGlue());
        hBox3.add(ftype);
        hBox3.add(this.fileType);
        hBox3.add(Box.createGlue());
        hBox3.add(label2);
        hBox3.add(this.fromFtp);
        vBox.add(hBox3);
        this.add(vBox);
    }

    public static void showDialog() {
        if (dialog != null) {
            dialog.setVisible(true);
            return;
        }
        dialog = new JDialog();
        dialog.setSize(new Dimension(600, 300));
        Box vBox = Box.createVerticalBox();
        vBox.add(instance);
        UIManager.LookAndFeelInfo[] lookAndFeels = UIManager.getInstalledLookAndFeels();
        JPanel panel = new JPanel();
        for (int i = 0; i < lookAndFeels.length; ++i) {
            JButton button = new JButton(lookAndFeels[i].getName());
            button.addActionListener(new MyAction(dialog));
            panel.add(button);
        }
        JTabbedPane jTab = new JTabbedPane();
        jTab.addTab("Select User Interface", null, panel, "Select the Look and Feel of the application.");
        vBox.add(jTab);
        vBox.add(Box.createGlue());
        JButton apply = new JButton("Apply");
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                instance.applyValues();
                dialog.dispose();
            }
        });
        JButton close = new JButton("Cancel");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispose();
            }
        });
        Box hBoxb = Box.createHorizontalBox();
        hBoxb.add(Box.createGlue());
        hBoxb.add((Component)close, "East");
        hBoxb.add((Component)apply, "East");
        vBox.add(hBoxb);
        dialog.getContentPane().add(vBox);
        dialog.setVisible(true);
    }

    protected void applyValues() {
        UserConfiguration config = WebStartMain.getWebStartConfig();
        String dir = this.pdbDir.getText();
        config.setPdbFilePath(dir);
        boolean fromFtpF = this.fromFtp.isSelected();
        if (fromFtpF) {
            config.setFetchBehavior(LocalPDBDirectory.FetchBehavior.FETCH_REMEDIATED);
        } else {
            config.setFetchBehavior(LocalPDBDirectory.FetchBehavior.LOCAL_ONLY);
        }
        String fileFormat = (String)this.fileType.getSelectedItem();
        config.setFileFormat(fileFormat);
        WebStartMain.persistConfig(config);
    }

    public JCheckBox getFromFtp() {
        return this.fromFtp;
    }

    public void setFromFtp(JCheckBox fromFtp) {
        System.out.println(fromFtp);
        this.fromFtp = fromFtp;
    }

    public JTextField getPDBDirField() {
        return this.pdbDir;
    }

    public void setPDBDirField(JTextField dir) {
        this.pdbDir = dir;
    }
}

