/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.jmol;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.ResidueNumber;

public class JmolTools {
    private static Pattern inscodePatter = Pattern.compile("([0-9]+)([a-zA-Z]*)?");

    public static final String getPdbInfo(Atom a) {
        return JmolTools.getPdbInfo(a, true);
    }

    public static void main(String[] args) {
        ChainImpl c = new ChainImpl();
        c.setChainID("X");
        AminoAcidImpl g = new AminoAcidImpl();
        g.setResidueNumber(ResidueNumber.fromString((String)"1A"));
        try {
            g.setPDBName("ALA");
        }
        catch (Exception e) {
            // empty catch block
        }
        AtomImpl a = new AtomImpl();
        a.setName("CA");
        g.addAtom((Atom)a);
        c.addGroup((Group)g);
        System.out.println(JmolTools.getPdbInfo((Atom)a));
    }

    public static final String getPdbInfo(Atom a, boolean printResName) {
        Group g1;
        String aa3 = "";
        String chain1 = "";
        String res1 = "";
        if (a != null && (g1 = a.getGroup()) != null) {
            aa3 = g1.getPDBName();
            res1 = g1.getResidueNumber().toString();
            Chain ch1 = g1.getChain();
            if (ch1 != null) {
                chain1 = ch1.getChainID();
            }
        }
        StringBuffer buf = new StringBuffer();
        if (printResName && !aa3.equals("")) {
            buf.append("[");
            buf.append(aa3);
            buf.append("]");
        }
        if (!res1.equals("")) {
            Matcher matcher = inscodePatter.matcher(res1);
            boolean found = matcher.find();
            if (!found) {
                System.err.println("JmolTools: could not parse the residue number string " + res1);
                buf.append(res1);
            } else {
                String residueNumber = matcher.group(1);
                String insCode = matcher.group(2);
                buf.append(residueNumber);
                if (insCode != null && !insCode.equals("")) {
                    buf.append("^");
                    buf.append(insCode);
                }
            }
        }
        if (!chain1.equals("")) {
            buf.append(":");
            buf.append(chain1);
        }
        return buf.toString();
    }
}

