/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.webstart;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.nbio.core.util.XMLWriter;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.ConfigXMLHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PersistentConfig {
    PersistenceService ps;
    BasicService bs;

    public PersistentConfig() throws UnavailableServiceException {
        try {
            this.ps = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            this.bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
        }
        catch (Exception e) {
            System.err.println("Can't init webstart - persistent configuration. " + e.getMessage());
        }
    }

    public void save(UserConfiguration config) {
        if (this.ps != null && this.bs != null) {
            this.saveWebStart(config);
        } else {
            System.err.println("can not save using persistentservice!");
        }
    }

    private void saveWebStart(UserConfiguration config) {
        try {
            URL codebase = this.bs.getCodeBase();
            FileContents fc = null;
            try {
                fc = this.ps.get(codebase);
                this.ps.delete(codebase);
            }
            catch (IOException e) {
                // empty catch block
            }
            this.ps.create(codebase, 3000000L);
            fc = this.ps.get(codebase);
            OutputStream os = fc.getOutputStream(true);
            PrintWriter pw = new PrintWriter(os, true);
            XMLWriter xw = config.toXML(pw);
            pw.flush();
            os.flush();
            xw.close();
            pw.close();
            os.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public UserConfiguration load() {
        if (this.ps != null && this.bs != null) {
            return this.loadWebStart();
        }
        System.err.println("can not load from persistentservice!");
        return null;
    }

    private UserConfiguration loadWebStart() {
        UserConfiguration config = null;
        try {
            URL codebase = this.bs.getCodeBase();
            FileContents fc = null;
            try {
                fc = this.ps.get(codebase);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            InputStream stream = fc.getInputStream();
            config = this.parseConfigFile(stream);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return config;
    }

    private UserConfiguration parseConfigFile(InputStream inStream) {
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            SAXParser saxParser = null;
            try {
                saxParser = spfactory.newSAXParser();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            XMLReader xmlreader = saxParser.getXMLReader();
            ConfigXMLHandler cont_handle = new ConfigXMLHandler();
            xmlreader.setContentHandler(cont_handle);
            xmlreader.setErrorHandler(new DefaultHandler());
            InputSource insource = new InputSource();
            insource.setByteStream(inStream);
            xmlreader.parse(insource);
            UserConfiguration config = cont_handle.getConfig();
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

