/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui.util.color;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import org.biojava.nbio.structure.gui.util.color.ContinuousColorMapper;

public class GradientPanel
extends JPanel {
    private static final long serialVersionUID = -6387922432121206731L;
    private ContinuousColorMapper mapper;
    private double min;
    private double max;

    public GradientPanel(ContinuousColorMapper mapper, double min, double max) {
        this.min = min;
        this.max = max;
        this.mapper = mapper;
        this.setPreferredSize(new Dimension(100, 20));
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int w = this.getWidth();
        int h = this.getHeight();
        g2.setStroke(new BasicStroke(1.0f));
        for (int i = 0; i < w; ++i) {
            double val = (this.max - this.min) * (double)i / (double)w + this.min;
            g2.setColor(this.mapper.getColor(val));
            g2.drawLine(i, 0, i, h);
        }
    }
}

