/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.autosuggest;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.biojava.nbio.structure.align.gui.autosuggest.AutoSuggestProvider;
import org.biojava.nbio.structure.scop.ScopDatabase;
import org.biojava.nbio.structure.scop.ScopDescription;
import org.biojava.nbio.structure.scop.ScopDomain;
import org.biojava.nbio.structure.scop.ScopFactory;

public class SCOPAutoSuggestProvider
implements AutoSuggestProvider {
    boolean DEBUG = false;
    int maxResults = 20;
    AtomicBoolean stop = new AtomicBoolean(false);

    @Override
    public Vector<String> getSuggestion(String userInput) {
        long timeS = System.currentTimeMillis();
        List<Object> domains = new ArrayList();
        domains = this.getPossibleScopDomains(userInput);
        Vector<String> v = new Vector<String>();
        int counter = 0;
        for (ScopDomain scopDomain : domains) {
            String scopId = scopDomain.getScopId();
            v.add(scopId);
            if (++counter <= this.maxResults) continue;
            break;
        }
        long timeE = System.currentTimeMillis();
        if (this.DEBUG) {
            System.out.println("ScopAutoSuggestProvider took " + (timeE - timeS) + " ms. to get " + v.size() + " suggestions");
        }
        return v;
    }

    private List<ScopDomain> getPossibleScopDomains(String userInput) {
        ArrayList<ScopDomain> domains = new ArrayList();
        ScopDatabase scop = ScopFactory.getSCOP();
        if (userInput.length() == 5 && userInput.startsWith("d") && !userInput.contains(".")) {
            userInput = userInput.substring(1);
        }
        if (userInput.length() == 4) {
            domains = scop.getDomainsForPDB(userInput);
        } else {
            int suni = -1;
            try {
                suni = Integer.parseInt(userInput);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (this.stop.get()) {
                return domains;
            }
            if (suni != -1) {
                domains = scop.getScopDomainsBySunid(Integer.valueOf(suni));
            }
            if (this.stop.get()) {
                return domains;
            }
            if ((domains == null || domains.size() < 1) && userInput.length() > 5) {
                domains.addAll(scop.filterByDomainName(userInput));
            }
            if (this.stop.get()) {
                return domains;
            }
            if (this.DEBUG) {
                System.out.println("domains: " + domains);
            }
            if ((domains == null || domains.size() < 1) && userInput.length() > 0) {
                List descs = scop.filterByClassificationId(userInput);
                if (descs == null || descs.size() < 1) {
                    descs = scop.filterByDescription(userInput);
                }
                for (ScopDescription d : descs) {
                    domains.addAll(scop.getScopDomainsBySunid(Integer.valueOf(d.getSunID())));
                    if (domains.size() > this.maxResults) break;
                    if (!this.stop.get()) continue;
                    return domains;
                }
            }
        }
        return domains;
    }

    @Override
    public void setMaxNrSuggestions(int maxNrSuggestions) {
        this.maxResults = maxNrSuggestions;
    }

    @Override
    public int getMaxNrSuggestions() {
        return this.maxResults;
    }

    @Override
    public void clear() {
    }

    @Override
    public void stop() {
        this.stop.set(true);
        if (this.DEBUG) {
            System.out.println("ScopAutoSuggestProvider got signal stop");
        }
    }
}

