/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.analysis;

import java.util.List;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.align.util.ResourceManager;
import org.biojava.nbio.structure.symmetry.core.AxisAligner;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryDetector;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryResults;
import org.biojava.nbio.structure.symmetry.core.RotationGroup;
import org.biojava.nbio.structure.symmetry.core.Subunits;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGenerator;

public class CalcBioAssemblySymmetry {
    private Structure bioAssembly;
    private QuatSymmetryParameters parameters;
    private QuatSymmetryResults results;
    private JmolSymmetryScriptGenerator scriptGenerator;
    public static String version;
    public static String build;

    public CalcBioAssemblySymmetry(Structure bioAssembly, QuatSymmetryParameters parameters) {
        this.bioAssembly = bioAssembly;
        this.parameters = parameters;
    }

    public QuatSymmetryParameters getParameters() {
        return this.parameters;
    }

    public QuatSymmetryDetector orient() {
        QuatSymmetryDetector detector = new QuatSymmetryDetector(this.bioAssembly, this.parameters);
        String defaultColoring = "";
        if (detector.hasProteinSubunits()) {
            for (QuatSymmetryResults globalSymmetry : detector.getGlobalSymmetry()) {
                String postFix = "g";
                AxisAligner aligner = AxisAligner.getInstance((QuatSymmetryResults)globalSymmetry);
                JmolSymmetryScriptGenerator generator = JmolSymmetryScriptGenerator.getInstance(aligner, postFix);
                generator.setOnTheFly(this.parameters.isOnTheFly());
                if (globalSymmetry.isPreferredResult()) {
                    this.results = globalSymmetry;
                    this.scriptGenerator = generator;
                }
                if (globalSymmetry.getSymmetry().equals("C1") && !globalSymmetry.getSubunits().isPseudoStoichiometric()) {
                    defaultColoring = generator.colorBySymmetry();
                }
                if (!this.parameters.isVerbose()) continue;
                System.out.println("Global symmetry: ");
                System.out.println(globalSymmetry);
                System.out.println(generator.drawAxes());
                System.out.println(generator.colorBySubunit());
                System.out.println(generator.colorBySequenceCluster());
                System.out.println(generator.colorBySymmetry());
            }
            for (List localSymmetries : detector.getLocalSymmetries()) {
                int count = 0;
                for (QuatSymmetryResults localSymmetry : localSymmetries) {
                    String postFix = "l" + count;
                    AxisAligner aligner = AxisAligner.getInstance((QuatSymmetryResults)localSymmetry);
                    JmolSymmetryScriptGenerator generator = JmolSymmetryScriptGenerator.getInstance(aligner, postFix);
                    generator.setOnTheFly(this.parameters.isOnTheFly());
                    generator.setDefaultColoring(defaultColoring);
                    if (localSymmetry.isPreferredResult()) {
                        this.results = localSymmetry;
                        this.scriptGenerator = generator;
                    }
                    if (!this.parameters.isVerbose()) continue;
                    System.out.println("Local symmetry: ");
                    System.out.println(localSymmetry);
                }
            }
        } else {
            System.out.println("No protein chains found for " + this.bioAssembly.getPDBCode());
        }
        return detector;
    }

    @Deprecated
    public RotationGroup getRotationGroup() {
        return this.results.getRotationGroup();
    }

    public Subunits getSubunits() {
        return this.results.getSubunits();
    }

    public String getSymmetry() {
        return this.results.getSymmetry();
    }

    public JmolSymmetryScriptGenerator getScriptGenerator() {
        return this.scriptGenerator;
    }

    static {
        try {
            ResourceManager about = ResourceManager.getResourceManager((String)"about");
            version = about.getString("project_version");
            build = about.getString("build");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

