/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.webstart;

import java.net.MalformedURLException;
import java.net.URL;
import org.biojava.nbio.structure.align.webstart.JNLPProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserOpener {
    private static final Logger logger = LoggerFactory.getLogger(BrowserOpener.class);

    public static boolean showDocument(URL url) {
        if (url != null) {
            boolean success = JNLPProxy.showDocument(url);
            if (!success) {
                logger.info("could not open URL " + url + " in browser. check your config or browser version.");
            }
            return success;
        }
        return false;
    }

    public static boolean showDocument(String urlstring) {
        try {
            URL url = new URL(urlstring);
            return BrowserOpener.showDocument(url);
        }
        catch (MalformedURLException e) {
            logger.warn("malformed URL {}", (Object)urlstring, (Object)e);
            return false;
        }
    }
}

