/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.align.StructurePairAligner;
import org.biojava.nbio.structure.align.pairwise.AlternativeAlignment;
import org.biojava.nbio.structure.gui.BiojavaJmol;
import org.biojava.nbio.structure.gui.ScaleableMatrixPanel;
import org.biojava.nbio.structure.gui.SequenceDisplay;
import org.biojava.nbio.structure.gui.events.JmolAlignedPositionListener;
import org.biojava.nbio.structure.gui.util.JButtonTableCellRenderer;
import org.biojava.nbio.structure.gui.util.JTableDataButtonModel;
import org.biojava.nbio.structure.gui.util.JTableMouseButtonListener;
import org.biojava.nbio.structure.gui.util.MatrixMouseListener;
import org.biojava.nbio.structure.gui.util.MyButtonMouseListener;
import org.biojava.nbio.structure.jama.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlternativeAlignmentFrame
extends JFrame {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = LoggerFactory.getLogger(AlternativeAlignmentFrame.class);
    private static String[] columnNames = new String[]{"#", "eqr", "score", "rms", "gaps", "cluster", "show distance matrix", "show alignment"};
    AlternativeAlignment[] aligs;
    JPanel panel = new JPanel();
    Structure structure1;
    Structure structure2;
    StructurePairAligner structurePairAligner;

    public AlternativeAlignmentFrame(Structure s1, Structure s2) {
        this.panel.setPreferredSize(new Dimension(800, 400));
        this.getContentPane().add(this.panel);
        this.structure1 = s1;
        this.structure2 = s2;
        String pdb1 = s1.getPDBCode();
        String pdb2 = s2.getPDBCode();
        String t = "Alternative Alignments";
        Object[] args = new Object[]{pdb1, pdb2};
        String title = MessageFormat.format(t, args);
        this.setTitle(title);
    }

    public void setStructurePairAligner(StructurePairAligner aligner) {
        this.structurePairAligner = aligner;
    }

    public void setAlternativeAlignments(AlternativeAlignment[] aligs) {
        this.aligs = aligs;
        this.panel.removeAll();
        Object[][] data = this.getDataFromAligs(aligs);
        JTableDataButtonModel model = new JTableDataButtonModel(data, columnNames);
        JTable table = new JTable(model);
        TableCellRenderer defaultRenderer = table.getDefaultRenderer(JButton.class);
        JButtonTableCellRenderer myRenderer = new JButtonTableCellRenderer(defaultRenderer);
        table.setDefaultRenderer(JButton.class, myRenderer);
        table.addMouseListener(new JTableMouseButtonListener(table));
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setPreferredSize(new Dimension(800, 400));
        this.panel.add(scrollPane);
    }

    private Object[][] getDataFromAligs(AlternativeAlignment[] aligs) {
        Object[][] data = new Object[aligs.length][columnNames.length];
        for (int i = 0; i < aligs.length; ++i) {
            AlternativeAlignment alig = aligs[i];
            data[i][0] = new Integer(i + 1);
            data[i][1] = new Integer(alig.getEqr());
            data[i][2] = new Double(alig.getScore());
            data[i][3] = new Double(alig.getRmsd());
            data[i][4] = new Integer(alig.getGaps());
            data[i][5] = new Integer(alig.getCluster());
            JButton maxb = new JButton("Distance Matrix");
            maxb.addMouseListener(new MatrixMouseListener(this, i));
            data[i][6] = maxb;
            JButton but = new JButton("Show in Jmol");
            but.addMouseListener(new MyButtonMouseListener(this, i));
            data[i][7] = but;
        }
        return data;
    }

    public void showDistanceMatrix(int position) {
        if (position > this.aligs.length) {
            return;
        }
        AlternativeAlignment alig = this.aligs[position];
        logger.info("display distance matrix for alternative alignment " + (position + 1));
        ScaleableMatrixPanel smp = new ScaleableMatrixPanel();
        JFrame frame = new JFrame();
        frame.setTitle("Alt. Alig [" + position + "] - Distance Matrix & path");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JFrame f = (JFrame)e.getSource();
                f.setVisible(false);
                f.dispose();
            }
        });
        smp.setMatrix(alig.getDistanceMatrix());
        smp.setAlternativeAligs(new AlternativeAlignment[]{alig});
        frame.getContentPane().add(smp);
        frame.pack();
        frame.setVisible(true);
    }

    public void showAlternative(int position) {
        if (position > this.aligs.length) {
            return;
        }
        AlternativeAlignment alig = this.aligs[position];
        logger.info("display alternative alignment " + (position + 1));
        Matrix m2 = alig.getRotationMatrix();
        String pdb1 = this.structure1.getPDBCode();
        String pdb2 = this.structure2.getPDBCode();
        AtomImpl shift1 = new AtomImpl();
        shift1.setCoords(new double[]{0.0, 0.0, 1.0});
        Atom shift2 = alig.getShift();
        Structure s3 = this.structure2.clone();
        Calc.rotate((Structure)s3, (Matrix)m2);
        Calc.shift((Structure)s3, (Atom)shift2);
        BiojavaJmol jmol = new BiojavaJmol();
        jmol.setTitle(pdb1 + " vs. " + pdb2);
        StructureImpl n = new StructureImpl();
        List chains1 = this.structure1.getChains();
        n.addModel(chains1);
        List chains3 = s3.getChains();
        n.addModel(chains3);
        jmol.setStructure((Structure)n);
        String[] cmds = this.createRasmolScripts(alig);
        jmol.evalString("model 0 ; select * ; wireframe off ; spacefill off; backbone 0.3;");
        jmol.evalString(cmds[0]);
        jmol.evalString(cmds[1]);
        JFrame frame = new JFrame("Sequences for AlternativeAlignment [" + position + "]");
        SequenceDisplay seqdisp = new SequenceDisplay(this.structurePairAligner);
        seqdisp.setStructure1(this.structure1);
        seqdisp.setStructure2(this.structure2);
        seqdisp.setAlternativeAlignment(alig);
        frame.getContentPane().add(seqdisp);
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JFrame f = (JFrame)e.getSource();
                f.setVisible(false);
                f.dispose();
            }
        });
        seqdisp.updateDisplay();
        JmolAlignedPositionListener jmolBridge = new JmolAlignedPositionListener(jmol, this.structurePairAligner);
        jmolBridge.setStructure1(this.structure1);
        jmolBridge.setStructure2(s3);
        seqdisp.addAlignmentPositionListener(jmolBridge);
    }

    private String[] createRasmolScripts(AlternativeAlignment alig) {
        String[] scripts = new String[2];
        Color col1 = Color.red;
        Color col2 = Color.blue;
        Color chaincol1 = new Color(col1.getRed() / 2, col1.getGreen() / 2, col1.getBlue() / 2);
        Color chaincol2 = new Color(col2.getRed() / 2, col2.getGreen() / 2, col2.getBlue() / 2);
        Object cmd1 = "";
        Object cmd2 = "";
        cmd1 = (String)cmd1 + "select */1; ";
        cmd1 = (String)cmd1 + " color [" + chaincol1.getRed() + "," + chaincol1.getGreen() + "," + chaincol1.getBlue() + "];";
        cmd2 = (String)cmd2 + "select */2; ";
        cmd2 = (String)cmd2 + " color [" + chaincol2.getRed() + "," + chaincol2.getGreen() + "," + chaincol2.getBlue() + "];";
        cmd1 = (String)cmd1 + "select ";
        cmd2 = (String)cmd2 + "select ";
        String[] pdb1s = alig.getPDBresnum1();
        String[] pdb2s = alig.getPDBresnum2();
        for (int i = 0; i < pdb1s.length; ++i) {
            String p1 = pdb1s[i];
            String p2 = pdb2s[i];
            cmd1 = (String)cmd1 + p1 + "/1";
            cmd2 = (String)cmd2 + p2 + "/2";
            if (i > pdb1s.length - 2) continue;
            cmd1 = (String)cmd1 + ",";
            cmd2 = (String)cmd2 + ",";
        }
        cmd1 = (String)cmd1 + "; color [" + col1.getRed() + "," + col1.getGreen() + "," + col1.getBlue() + "];";
        cmd1 = (String)cmd1 + " backbone 0.6;";
        cmd2 = (String)cmd2 + "; color [" + col2.getRed() + "," + col2.getGreen() + "," + col2.getBlue() + "];";
        cmd2 = (String)cmd2 + " backbone 0.6;";
        scripts[0] = cmd1;
        scripts[1] = cmd2;
        return scripts;
    }
}

