/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui.events;

import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.align.StructurePairAligner;
import org.biojava.nbio.structure.gui.BiojavaJmol;
import org.biojava.nbio.structure.gui.events.AlignmentPositionListener;
import org.biojava.nbio.structure.gui.util.AlignedPosition;

public class JmolAlignedPositionListener
implements AlignmentPositionListener {
    BiojavaJmol parent;
    Atom[] ca1;
    Atom[] ca2;
    StructurePairAligner structurePairAligner;

    public JmolAlignedPositionListener(BiojavaJmol parent, StructurePairAligner alig) {
        this.parent = parent;
        this.structurePairAligner = alig;
    }

    public void setStructure1(Structure structure1) {
        this.ca1 = this.structurePairAligner.getAlignmentAtoms(structure1);
    }

    public void setStructure2(Structure structure2) {
        this.ca2 = this.structurePairAligner.getAlignmentAtoms(structure2);
    }

    @Override
    public void mouseOverPosition(AlignedPosition p) {
        Chain c;
        Group parent;
        Atom a;
        int p1 = p.getPos1();
        int p2 = p.getPos2();
        Object s = "select ";
        if (p1 > this.ca1.length || p2 > this.ca2.length) {
            System.err.println("requsting atom out of bounds! ");
            return;
        }
        Object pdbpos1 = "";
        Object pdbpos2 = "";
        if (p1 > -1) {
            a = this.ca1[p1];
            parent = a.getGroup();
            c = parent.getChain();
            pdbpos1 = parent.getResidueNumber().toString();
            if (!" ".equals(c.getId())) {
                pdbpos1 = (String)pdbpos1 + ":" + c.getId();
            }
            s = (String)s + (String)pdbpos1 + "/1";
        }
        if (p2 > -1) {
            a = this.ca2[p2];
            parent = a.getGroup();
            c = parent.getChain();
            pdbpos2 = parent.getResidueNumber().toString();
            if (!" ".equals(c.getId())) {
                pdbpos2 = (String)pdbpos2 + ":" + c.getId();
            }
            if (p1 > -1) {
                s = (String)s + ",";
            }
            s = (String)s + (String)pdbpos2 + "/2";
        }
        s = (String)s + "; set display selected;";
        this.parent.evalString((String)s);
    }

    @Override
    public void positionSelected(AlignedPosition p) {
        this.mouseOverPosition(p);
    }

    @Override
    public void rangeSelected(AlignedPosition start, AlignedPosition end) {
    }

    @Override
    public void selectionLocked() {
    }

    @Override
    public void selectionUnlocked() {
    }

    @Override
    public void toggleSelection(AlignedPosition p) {
    }
}

