/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownloadUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileDownloadUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dst) throws IOException {
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(src).getChannel();
            destination = new FileOutputStream(dst).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static String getFileExtension(File f) {
        String fileName = f.getName();
        String ext = "";
        int mid = fileName.lastIndexOf(".");
        ext = fileName.substring(mid + 1, fileName.length());
        return ext;
    }

    public static String getFilePrefix(File f) {
        String fileName = f.getName();
        String fname = "";
        int mid = fileName.indexOf(".");
        fname = fileName.substring(0, mid);
        return fname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(URL url, File destination) throws IOException {
        int count = 0;
        int maxTries = 10;
        int timeout = 60000;
        File tempFile = File.createTempFile(FileDownloadUtils.getFilePrefix(destination), "." + FileDownloadUtils.getFileExtension(destination));
        Channel rbc = null;
        FileOutputStream fos = null;
        while (true) {
            try {
                URLConnection connection = FileDownloadUtils.prepareURLConnection(url.toString(), timeout);
                connection.connect();
                InputStream inputStream = connection.getInputStream();
                rbc = Channels.newChannel(inputStream);
                fos = new FileOutputStream(tempFile);
                fos.getChannel().transferFrom((ReadableByteChannel)rbc, 0L, Long.MAX_VALUE);
            }
            catch (SocketTimeoutException e) {
                if (++count != maxTries) continue;
                throw e;
            }
            finally {
                if (rbc != null) {
                    rbc.close();
                }
                if (fos == null) continue;
                fos.close();
                continue;
            }
            break;
        }
        logger.debug("Copying temp file {} to final location {}", (Object)tempFile, (Object)destination);
        FileDownloadUtils.copy(tempFile, destination);
        tempFile.delete();
    }

    public static String toUnixPath(String path) {
        String uPath = path;
        if (uPath.contains("\\")) {
            uPath = uPath.replaceAll("\\\\", "/");
        }
        if (uPath.endsWith("//")) {
            uPath = uPath.substring(0, uPath.length() - 1);
        }
        if (!uPath.endsWith("/")) {
            uPath = uPath + "/";
        }
        return uPath;
    }

    public static String expandUserHome(String file) {
        if (file.startsWith("~" + File.separator)) {
            file = System.getProperty("user.home") + file.substring(1);
        }
        return file;
    }

    public static boolean ping(String url, int timeout) {
        try {
            HttpURLConnection connection = (HttpURLConnection)FileDownloadUtils.prepareURLConnection(url, timeout);
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            return 200 <= responseCode && responseCode <= 399;
        }
        catch (IOException exception) {
            return false;
        }
    }

    public static URLConnection prepareURLConnection(String url, int timeout) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        connection.setReadTimeout(timeout);
        connection.setConnectTimeout(timeout);
        return connection;
    }

    public static void deleteDirectory(Path dir) throws IOException {
        if (dir == null || !Files.exists(dir, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e != null) {
                    throw e;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteDirectory(String dir) throws IOException {
        FileDownloadUtils.deleteDirectory(Paths.get(dir, new String[0]));
    }

    public static void main(String[] args) {
        String url = "http://scop.mrc-lmb.cam.ac.uk/scop/parse/";
        System.out.format("%s\t%s%n", FileDownloadUtils.ping(url, 200), url);
        url = "http://scop.mrc-lmb.cam.ac.uk/scop/parse/foo";
        System.out.format("%s\t%s%n", FileDownloadUtils.ping(url, 200), url);
        url = "http://scopzzz.mrc-lmb.cam.ac.uk/scop/parse/";
        System.out.format("%s\t%s%n", FileDownloadUtils.ping(url, 200), url);
        url = "scop.mrc-lmb.cam.ac.uk";
        System.out.format("%s\t%s%n", FileDownloadUtils.ping(url, 200), url);
        url = "http://scop.mrc-lmb.cam.ac.uk";
        System.out.format("%s\t%s%n", FileDownloadUtils.ping(url, 200), url);
    }
}

