/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.geometry;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.jama.EigenvalueDecomposition;
import org.biojava.nbio.structure.jama.Matrix;

public class MomentsOfInertia {
    private List<Point3d> points = new ArrayList<Point3d>();
    private List<Double> masses = new ArrayList<Double>();
    private boolean modified = true;
    private double[] principalMomentsOfInertia = new double[3];
    private Vector3d[] principalAxes = new Vector3d[3];

    public void addPoint(Point3d point, double mass) {
        this.points.add(point);
        this.masses.add(mass);
        this.modified = true;
    }

    public Point3d centerOfMass() {
        if (this.points.size() == 0) {
            throw new IllegalStateException("MomentsOfInertia: no points defined");
        }
        Point3d center = new Point3d();
        double totalMass = 0.0;
        int n = this.points.size();
        for (int i = 0; i < n; ++i) {
            double mass = this.masses.get(i);
            totalMass += mass;
            center.scaleAdd(mass, (Tuple3d)this.points.get(i), (Tuple3d)center);
        }
        center.scale(1.0 / totalMass);
        return center;
    }

    public double[] getPrincipalMomentsOfInertia() {
        if (this.modified) {
            this.diagonalizeTensor();
            this.modified = false;
        }
        return this.principalMomentsOfInertia;
    }

    public Vector3d[] getPrincipalAxes() {
        if (this.modified) {
            this.diagonalizeTensor();
            this.modified = false;
        }
        return this.principalAxes;
    }

    public double[] getElipsisRadii() {
        if (this.modified) {
            this.diagonalizeTensor();
            this.modified = false;
        }
        double m = 0.0;
        int n = this.points.size();
        for (int i = 0; i < n; ++i) {
            m += this.masses.get(i).doubleValue();
        }
        double[] r = new double[3];
        for (int i = 0; i < 3; ++i) {
            r[i] = Math.sqrt(this.principalMomentsOfInertia[i] / m);
        }
        return r;
    }

    public double getRadiusOfGyration() {
        Point3d c = this.centerOfMass();
        Point3d t = new Point3d();
        double sum = 0.0;
        int n = this.points.size();
        for (int i = 0; i < n; ++i) {
            t.set((Tuple3d)this.points.get(i));
            sum += t.distanceSquared(c);
        }
        return Math.sqrt(sum /= (double)this.points.size());
    }

    public SymmetryClass getSymmetryClass(double threshold) {
        boolean c2;
        if (this.modified) {
            this.diagonalizeTensor();
            this.modified = false;
        }
        double ia = this.principalMomentsOfInertia[0];
        double ib = this.principalMomentsOfInertia[1];
        double ic = this.principalMomentsOfInertia[2];
        boolean c1 = (ib - ia) / (ib + ia) < threshold;
        boolean bl = c2 = (ic - ib) / (ic + ib) < threshold;
        if (c1 && c2) {
            return SymmetryClass.SYMMETRIC;
        }
        if (c1) {
            return SymmetryClass.OBLATE;
        }
        if (c2) {
            return SymmetryClass.PROLATE;
        }
        return SymmetryClass.ASYMMETRIC;
    }

    public double symmetryCoefficient() {
        if (this.modified) {
            this.diagonalizeTensor();
            this.modified = false;
        }
        double ia = this.principalMomentsOfInertia[0];
        double ib = this.principalMomentsOfInertia[1];
        double ic = this.principalMomentsOfInertia[2];
        double c1 = 1.0 - (ib - ia) / (ib + ia);
        double c2 = 1.0 - (ic - ib) / (ic + ib);
        return Math.max(c1, c2);
    }

    public double getAsymmetryParameter(double threshold) {
        if (this.modified) {
            this.diagonalizeTensor();
            this.modified = false;
        }
        if (this.getSymmetryClass(threshold).equals((Object)SymmetryClass.SYMMETRIC)) {
            return 0.0;
        }
        double a = 1.0 / this.principalMomentsOfInertia[0];
        double b = 1.0 / this.principalMomentsOfInertia[1];
        double c = 1.0 / this.principalMomentsOfInertia[2];
        return (2.0 * b - a - c) / (a - c);
    }

    public double[][] getInertiaTensor() {
        Point3d p = new Point3d();
        double[][] tensor = new double[3][3];
        Point3d com = this.centerOfMass();
        int n = this.points.size();
        for (int i = 0; i < n; ++i) {
            double mass = this.masses.get(i);
            p.sub((Tuple3d)this.points.get(i), (Tuple3d)com);
            double[] dArray = tensor[0];
            dArray[0] = dArray[0] + mass * (p.y * p.y + p.z * p.z);
            double[] dArray2 = tensor[1];
            dArray2[1] = dArray2[1] + mass * (p.x * p.x + p.z * p.z);
            double[] dArray3 = tensor[2];
            dArray3[2] = dArray3[2] + mass * (p.x * p.x + p.y * p.y);
            double[] dArray4 = tensor[0];
            dArray4[1] = dArray4[1] - mass * p.x * p.y;
            double[] dArray5 = tensor[0];
            dArray5[2] = dArray5[2] - mass * p.x * p.z;
            double[] dArray6 = tensor[1];
            dArray6[2] = dArray6[2] - mass * p.y * p.z;
        }
        tensor[1][0] = tensor[0][1];
        tensor[2][0] = tensor[0][2];
        tensor[2][1] = tensor[1][2];
        return tensor;
    }

    private void diagonalizeTensor() {
        Matrix m = new Matrix(this.getInertiaTensor());
        EigenvalueDecomposition eig = m.eig();
        this.principalMomentsOfInertia = eig.getRealEigenvalues();
        double[][] eigenVectors = eig.getV().getArray();
        this.principalAxes[0] = new Vector3d(eigenVectors[0][0], eigenVectors[1][0], eigenVectors[2][0]);
        this.principalAxes[1] = new Vector3d(eigenVectors[0][1], eigenVectors[1][1], eigenVectors[2][1]);
        this.principalAxes[2] = new Vector3d(eigenVectors[0][2], eigenVectors[1][2], eigenVectors[2][2]);
    }

    public static enum SymmetryClass {
        LINEAR,
        PROLATE,
        OBLATE,
        SYMMETRIC,
        ASYMMETRIC;

    }
}

