/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.rcsb;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.biojava.nbio.structure.rcsb.RCSBDescription;
import org.biojava.nbio.structure.rcsb.RCSBMacromolecule;
import org.biojava.nbio.structure.rcsb.RCSBPolymer;
import org.biojava.nbio.structure.rcsb.RCSBTaxonomy;
import org.biojava.nbio.structure.rcsb.ReadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RCSBDescriptionFactory {
    private static final Logger logger = LoggerFactory.getLogger(RCSBDescriptionFactory.class);
    private static final String URL_STUB = "http://www.rcsb.org/pdb/rest/describeMol?structureId=";

    public static RCSBDescription get(InputStream stream) {
        NodeList data;
        try {
            data = ReadUtils.getNodes(stream);
        }
        catch (IOException e) {
            logger.warn("Couldn't parse XML", (Throwable)e);
            return null;
        }
        RCSBDescription description = new RCSBDescription();
        Node structureIdE = null;
        for (int i = 0; i < data.getLength(); ++i) {
            if (data.item(i).getNodeType() != 1 || !(structureIdE = (Element)data.item(i)).getNodeName().equals("structureId")) continue;
            description.setPdbId(structureIdE.getAttribute("id"));
        }
        data = structureIdE.getChildNodes();
        Element polymerE = null;
        for (int i = 0; i < data.getLength(); ++i) {
            if (data.item(i).getNodeType() != 1 || !(polymerE = (Element)data.item(i)).getNodeName().equals("polymer")) continue;
            RCSBPolymer polymer = RCSBDescriptionFactory.makePolymer(polymerE);
            description.addPolymer(polymer);
        }
        return description;
    }

    public static RCSBDescription get(String pdbId) {
        InputStream is;
        try {
            URL url = new URL(URL_STUB + pdbId);
            is = url.openConnection().getInputStream();
        }
        catch (IOException e) {
            logger.warn("Couldn't open connection", (Throwable)e);
            return null;
        }
        return RCSBDescriptionFactory.get(is);
    }

    private static RCSBMacromolecule makeMolecule(Element moleculeE) {
        RCSBMacromolecule molecule = new RCSBMacromolecule();
        molecule.setName(moleculeE.getAttribute("name"));
        Element element = null;
        NodeList data = moleculeE.getChildNodes();
        for (int i = 0; i < data.getLength(); ++i) {
            if (data.item(i).getNodeType() != 1 || !(element = (Element)data.item(i)).getNodeName().equals("accession")) continue;
            molecule.addAccession(element.getAttribute("id"));
        }
        return molecule;
    }

    private static RCSBPolymer makePolymer(Element polymerE) {
        RCSBPolymer polymer = new RCSBPolymer();
        polymer.setIndex(ReadUtils.toInt(polymerE.getAttribute("entityNr")));
        polymer.setLength(ReadUtils.toInt(polymerE.getAttribute("length")));
        polymer.setWeight(ReadUtils.toDouble(polymerE.getAttribute("weight")));
        polymer.setType(ReadUtils.toStr(polymerE.getAttribute("type")));
        Element element = null;
        NodeList data = polymerE.getChildNodes();
        for (int i = 0; i < data.getLength(); ++i) {
            if (data.item(i).getNodeType() != 1) continue;
            element = (Element)data.item(i);
            if (element.getNodeName().equals("chain")) {
                RCSBDescriptionFactory.parseChains(polymer, element.getAttribute("id"));
                continue;
            }
            if (element.getNodeName().equals("Taxonomy")) {
                String name = element.getAttribute("name");
                int id = ReadUtils.toInt(element.getAttribute("id"));
                RCSBTaxonomy taxonomy = new RCSBTaxonomy(name, id);
                polymer.setTaxonomy(taxonomy);
                continue;
            }
            if (element.getNodeName().equals("macroMolecule")) {
                RCSBMacromolecule molecule = RCSBDescriptionFactory.makeMolecule(element);
                polymer.setMolecule(molecule);
                continue;
            }
            if (element.getNodeName().equals("polymerDescription")) {
                polymer.setDescription(element.getAttribute("description"));
                continue;
            }
            if (element.getNodeName().equals("enzClass")) {
                polymer.setEnzClass(element.getAttribute("ec"));
                continue;
            }
            if (!element.getNodeName().equals("synonym")) continue;
            RCSBDescriptionFactory.parseSynonyms(polymer, element.getAttribute("name"));
        }
        return polymer;
    }

    private static void parseChains(RCSBPolymer polymer, String string) {
        String[] parts;
        for (String part : parts = string.split("\\s*,\\s*")) {
            if (part.length() == 1) {
                polymer.addChain(part.charAt(0));
                continue;
            }
            logger.warn("Chain id contained more than one character");
        }
    }

    private static void parseSynonyms(RCSBPolymer polymer, String string) {
        String[] parts;
        for (String part : parts = string.split("\\s*,\\s*")) {
            polymer.addSynonym(part);
        }
    }
}

